% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zsh.R
\name{zsh}
\alias{zsh}
\alias{glog}
\alias{gcc}
\alias{gcmsg}
\alias{gco}
\alias{gcb}
\alias{gpr}
\alias{gp}
\alias{gpu}
\alias{gpd}
\alias{gst}
\alias{gss}
\alias{gba}
\alias{gbd}
\alias{gbmm}
\alias{gbnm}
\alias{gbm}
\alias{ga}
\alias{gaa}
\alias{gau}
\alias{gsta}
\alias{gstl}
\alias{gstaa}
\alias{gstd}
\alias{gstc}
\alias{gsts}
\alias{gpop}
\alias{gstp}
\alias{gtn}
\alias{gfa}
\alias{gac}
\alias{gwip}
\alias{gclean}
\alias{gdf}
\alias{gpf}
\alias{gnuke}
\alias{gcf}
\alias{gcm}
\alias{grm}
\alias{grbc}
\alias{grba}
\alias{grbs}
\alias{grbm}
\alias{grv}
\title{Z-shell Aliases}
\usage{
glog(n = 10L)

gcc(...)

gcmsg(msg = "wip")

gco(branch = NULL)

gcb(branch = NULL)

gpr()

gp(...)

gpu()

gpd()

gst()

gss()

gba()

gbd(branch = NULL, force = FALSE)

gbmm(branch = gitr_default_br())

gbnm(branch = gitr_default_br())

gbm(branch = NULL)

ga(...)

gaa()

gau()

gsta()

gstl()

gstaa(n = 0)

gstd(n = 0)

gstc()

gsts(text = FALSE)

gpop()

gstp()

gtn()

gfa()

gac()

gwip()

gclean(dry_run = TRUE)

gdf(file = NULL, staged = FALSE)

gpf()

gnuke()

gcf(global = FALSE)

gcm()

grm(...)

grbc()

grba()

grbs()

grbm()

grv()
}
\arguments{
\item{n}{\code{integer(1)}. How far back to go from current \code{HEAD}.
Same as the command line \verb{git log -n} parameter.
For \verb{git stash} commands, zero-index into the stash list.}

\item{...}{Additional arguments passed to the system
command-line \verb{git <command> [<args>]} call.}

\item{msg}{\code{character(1)}. The message for the commit subject line.}

\item{branch}{\code{character(1)}. The name of a branch, typically a
feature branch.}

\item{force}{\code{logical(1)}. Should the branch
delete be forced with the \code{-D} flag?}

\item{text}{\code{logical(1)}. Show the text diffs from the stash.}

\item{dry_run}{\code{logical(1)}. Clean as dry-run?}

\item{file}{A full file path within the repository to diff.}

\item{staged}{\code{logical(1)}. Compare a staged file to \code{HEAD}?
Otherwise the working directory is compared to the
index (\code{staged} or \code{HEAD}).}

\item{global}{\code{logical(1)}. Query global repository.
Alternatively local configuration only.}
}
\value{
Most aliases invisibly return \code{NULL} ... with some exceptions.
}
\description{
Provides functions to common Z-shell git plugin aliases.
}
\section{Functions}{
\itemize{
\item \code{glog()}: Get the \code{git} log in a pretty format for the
\code{n} most recent commits.

\item \code{gcc()}: \verb{git commit ...}. To avoid masking the \code{\link[base:gc]{base::gc()}} function,
this alias has been re-mapped to \code{\link[=gcc]{gcc()}}.

\item \code{gcmsg()}: \verb{git commit -m <msg>}.

\item \code{gco()}: \verb{git checkout}.

\item \code{gcb()}: \verb{git checkout -b <branch>}.

\item \code{gpr()}: \verb{git pull --rebase}.

\item \code{gp()}: \verb{git push}.

\item \code{gpu()}: \verb{git push -u origin}.

\item \code{gpd()}: \verb{git push --dry-run}.

\item \code{gst()}: \verb{git status}.

\item \code{gss()}: \verb{git status -s}.

\item \code{gba()}: \verb{git branch -a}.

\item \code{gbd()}: \verb{git branch -dD}.

\item \code{gbmm()}: \verb{git branch --merged <branch>}.

\item \code{gbnm()}: \verb{git branch --no-merged <branch>}.

\item \code{gbm()}: \verb{git branch -m}.

\item \code{ga()}: \verb{git add ...}.

\item \code{gaa()}: \verb{git add --all}.

\item \code{gau()}: \verb{git add -u}.

\item \code{gsta()}: \verb{git stash}.

\item \code{gstl()}: \verb{git stash list}.

\item \code{gstaa()}: \verb{git stash apply}.
\strong{Note} zero-indexing!

\item \code{gstd()}: \verb{git stash drop}.
\strong{Note} zero-indexing!

\item \code{gstc()}: \verb{git stash clear}. Danger!

\item \code{gsts()}: \verb{git stash show}.

\item \code{gpop()}: \verb{git stash pop --quiet --index}.

\item \code{gstp()}: See \code{gpop()}.

\item \code{gtn()}: \verb{git tag -n}.

\item \code{gfa()}: \verb{git fetch --all --prune}.

\item \code{gac()}: \verb{git commit --no-verify --amend --no-edit}.

\item \code{gwip()}: \verb{git commit --no-verify -m 'wip'}.

\item \code{gclean()}: \verb{git clean -f -d}.

\item \code{gdf()}: \verb{git diff <file>}.

\item \code{gpf()}: \verb{git push --force-with-lease}.

\item \code{gnuke()}: \verb{git reset --hard && git clean -df}.

\item \code{gcf()}: \verb{git config --local} or \verb{git config --global}.

\item \code{gcm()}: Checkout the default branch.

\item \code{grm()}: \verb{git rm ...}.

\item \code{grbc()}: \verb{git rebase --continue}.

\item \code{grba()}: \verb{git rebase --abort}.

\item \code{grbs()}: \verb{git rebase --skip}.

\item \code{grbm()}: \verb{git rebase gitr_default_br()}.

\item \code{grv()}: \verb{git remote -v}.

}}
\examples{
\dontrun{
  glog()
}
}
