% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tainan2020dataset.R
\docType{data}
\name{tainan2020dataset}
\alias{tainan2020dataset}
\title{EHR data of patients affected by Glioblastoma (GBM) from Tainan and Taiwan medical centers and branches.}
\format{
A data frame with 84 rows and 12 variables:
\describe{
 \item{age_years}{Numeric. Patient's age.}
 \item{chemo_yes1_no0}{Factor. "No" (0) or "Yes" (1) for chemotherapy.}
 \item{OS_months}{Numeric. Overall Survival expressed in months.}
 \item{PFS_months}{Numeric. Progress Free Survival expressed in months.}
 \item{radiation_dose_Gy}{Numeric. Radiation dose used in chemotherapy expressed in Gy.}
 \item{radiation_volume_mL}{Numeric. Radiation volume used in chemotherapy expressed in mL.}
 \item{sex_male0_female1}{Factor. "Male" (0) or "Female" (1).}
 \item{surgery_resection1_biopsy0}{Factor. "Biopsy" (0) or "Resection" (1) for surgery}
 \item{survived_yes1_no0}{Factor. "Dead" (0) or "Alive" (1) at their most recent check-up.}
 \item{TMZ_based_chemo_yes1_no0}{Factor. "No" (0) or "Yes" (1) for TMZ based chemotherapy.}
 \item{tumorProgression_no0_yes1}{Factor. "No" (0) or "Yes" (1) for tumor progression after the initial treatment.}
 \item{year_of_diagnosis_05to10_0_10to16_1}{Factor. "2005-2010" (0) or "2010-2016" (1) for the year of diagnosis.}
}
}
\usage{
data(tainan2020dataset)
}
\description{
Data form patients affected by GBM in the Tainan and Taiwan medical centers and affiliated branches between 2005 and 2016.\cr
It contains data from 84 patients, ranging from demographical information (age and sex) and
treatment characteristics (chemotherapy, radiation volume and dose) to
surgical details and outcomes (Overall and Progress Free Survival).\cr
The dataset focuses on the impact of radiation volume and dose;
it finds that patients with an elevated radiation dose (>60.0 Gy) had better median PFS and OS compared to patients who received a standard radiation dose.\cr
Some data may be missing due to the nature of clinical records.
}
\examples{

data(tainan2020dataset)
head(tainan2020dataset)

}
\references{
Li-Tsun Shieh, How-Ran Guo, Chung-Han Ho et al. (2020).
Survival of glioblastoma treated with a moderately escalated radiation dose—Results of a retrospective analysis.
PMID: 32413077.
15(5): e0233188.
https://doi.org/10.1371/journal.pone.0233188
}
\keyword{datasets}
