% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.R
\name{stfamily}
\alias{stfamily}
\alias{vpoisson}
\alias{vquasipoisson}
\alias{vnegative.binomial}
\alias{vbinomial}
\alias{vquasibinomial}
\alias{vgamma}
\alias{vinverse.gaussian}
\alias{vnormal}
\title{Families for spatio-temporal GLMs}
\usage{
vpoisson(
  link = c("log", "identity", "sqrt", "softplus"),
  const = 1,
  copula = NULL,
  copula_param = NULL,
  sampling_method = c("inversion", "poisson_process")
)

vquasipoisson(
  link = c("log", "identity", "sqrt", "softplus"),
  dispersion = NULL,
  const = 1,
  copula = NULL,
  copula_param = NULL,
  sampling_method = c("build_up", "chop_down", "branching", "negbin")
)

vnegative.binomial(
  link = c("log", "identity", "sqrt", "softplus"),
  dispersion = NULL,
  const = 1,
  copula = NULL,
  copula_param = NULL
)

vbinomial(
  link = c("softclipping", "identity", "logit", "probit"),
  size = 1,
  const = 1,
  copula = NULL,
  copula_param = NULL
)

vquasibinomial(
  link = c("softclipping", "identity", "logit", "probit"),
  size = 1,
  dispersion = NULL,
  const = 1,
  copula = NULL,
  copula_param = NULL
)

vgamma(
  link = c("inverse", "log", "identity"),
  dispersion = NULL,
  copula = NULL,
  copula_param = NULL
)

vinverse.gaussian(
  link = c("1/mu^2", "inverse", "identity", "log"),
  dispersion = NULL,
  copula = NULL,
  copula_param = NULL
)

vnormal(
  link = c("identity", "log", "inverse"),
  dispersion = NULL,
  copula = NULL,
  copula_param = NULL
)
}
\arguments{
\item{link}{Character string specifying the link function.
Options depend on the distribution (see Details).}

\item{const}{Optional numeric constant used in some link functions.}

\item{copula}{Optional copula family to model dependence between responses. Has no effect on parameter estimation, but only on situations in which data is generated with this family.}

\item{copula_param}{Parameter for the copula. (Numeric scalar of length 1)}

\item{sampling_method}{Sampling algorithm for Poisson and quasi-Poisson.}

\item{dispersion}{Optional dispersion parameter(s). Can be either a numerical scalar describing a global,
time-invariant dispersion parameter, a vector with (temporal) constant dispersion parameters for each location,
or a matrix with dispersion parameters for each location and time. (Rows are locations, columns are time points)
If \code{NULL}, dispersion will be estimated as a scalar where applicable.}

\item{size}{Number of trials for binomial-type families.}
}
\value{
An object of class \code{"stfamily"} containing elements
such as \code{link}, \code{distribution}, \code{variance}, \code{dev.resids}.
}
\description{
These functions create family objects for various distributions used in
spatio-temporal generalized linear models (STGLMs).
Each function returns an object of class \code{"stfamily"} describing a
(conditional) marginal distribution, a link function, and optional dispersion values.
The output is intended only for use within this package and is processed internally in the functions of this package.
}
\details{
The \code{link} argument specifies the link function to be used for the family. The available link functions depend on the distribution:
\itemize{
\item Poisson, Quasi-Poisson, Negative-Binomial: "log", "identity", "sqrt", "softplus"
\item Binomial, Quasi-Binomial: "softclipping", "identity", "logit", "probit"
\item Gamma: "inverse", "log", "identity"
\item Inverse Gaussian: "1/mu^2", "inverse", "identity", "log"
\item Gaussian/Normal: "identity", "log", "inverse"
}

The following families are available:
\itemize{
\item \code{vpoisson()} – Poisson distribution
\item \code{vquasipoisson()} – Quasi-Poisson, i.e. Poisson like, but dispersion can differ from 1
\item \code{vnegative.binomial()} – Negative binomial distribution
\item \code{vbinomial()} – Binomial distribution
\item \code{vquasibinomial()} – Quasi-Binomial, i.e. Binomial like, but dispersion can differ from 1
\item \code{vgamma()} – Gamma distribution
\item \code{vinverse.gaussian()} – Inverse Gaussian distribution
\item \code{vnormal()} – Gaussian distribution
\item \code{vgarch()} – GARCH distribution
}

The following copulas are available:
\itemize{
\item "normal" – Gaussian copula
\item "t" – t copula
\item "clayton" – Clayton copula
\item "frank" – Frank copula
\item "gumbel" – Gumbel copula
\item "joe" – Joe copula
}
The data generating processes of each distribution rely on (sequences of) uniform marginals, which are transformed to obtain the observed data.
The copula specifies the dependence structure between these uniform marginals. If no copula (\code{copula = NULL}) is specified, the uniform marginals are generated independent.

For most distributions, the data generation is based on inversion of the cumulative distribution function (CDF).
For the Poisson distribution, two different sampling methods are implemented:
\code{sampling_method = "inversion"} results in the inversion method using \code{qpois} and \code{sampling_method = "poisson_process"} implements the Poisson process method described in Fokianos et al. (2020).
For a quasi-Poisson model, four different sampling methods are implemented: \code{sampling_method = "build_up"}, \code{sampling_method = "chop_down"}, \code{sampling_method = "branching"} and \code{sampling_method = "negbin"}.
The first three methods generate data from a generalized Poisson distribution, see Consul and Jain (1973) and are described in Demirtas (2017). The \code{sampling_method = "negbin"} uses the Inversion method on properly parameterized negative binomial distribution to generate the data.
If the "branching" or "negbin" method is used, only overdispersion can be generated. Dispersion values resulting in underdispersion will be set to 1, i.e. a standard Poisson case.
For Quasi-Binomial models, in case of overdispersion, the data is generated from a sequence of positive correlated Bernoulli trials, see Ahn and Chen (1995) for a discussion. In case of underdispersion, data is generated using a normal approximation.
In case of the inverse Gaussian distribution, data is generated using the Michael-Schucany-Haas method, see Michael et al. (1976).

Note that for the negative binomial family, the dispersion parameter corresponds to the shape parameter of the negative binomial distribution.
}
\examples{
fam <- vpoisson(link = "log")
print(fam)

fam2 <- vbinomial(link = "logit", size = 10)
print(fam2)

}
\references{
\itemize{
\item Ahn, H., & Chen, J. J. (1995). Generation of Over-Dispersed and Under-Dispersed Binomial Variates. Journal of Computational and Graphical Statistics, 4(1), 55–64. \doi{10.1080/10618600.1995.10474665}
\item Consul, P. C., & Jain, G. C. (1973). A Generalization of the Poisson Distribution. Technometrics, 15(4), 791–799. \doi{10.1080/00401706.1973.10489112}
\item Demirtas, H. (2017). On accurate and precise generation of generalized Poisson variates. Communications in Statistics - Simulation and Computation, 46(1), 489–499. \doi{10.1080/03610918.2014.968725}
\item Fokianos, K., Støve, B., Tjøstheim, D., & Doukhan, P. (2020). Multivariate count autoregression. Bernoulli, 26(1), 471–499. \doi{10.3150/19-BEJ1132}
\item Michael, J. R., Schucany, W. R., & Haas, R. W. (1976). Generating Random Variates Using Transformations with Multiple Roots. The American Statistician, 30(2), 88–90. \doi{10.1080/00031305.1976.10479147}
}
}
\seealso{
\code{\link[stats]{family}}
}
