% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmFEL-helpers.R
\name{glmmfe_resolve_family}
\alias{glmmfe_resolve_family}
\title{Resolve supported family specifications}
\usage{
glmmfe_resolve_family(family)
}
\arguments{
\item{family}{Character label or a \code{stats::family()} object.}
}
\value{
A canonical family label.
}
\description{
Internal helper that normalizes user family input into one of the canonical
labels used by the internal FE/Laplace code:
\itemize{
\item \code{"binomial_probit"}
\item \code{"binomial_logit"}
\item \code{"poisson_log"}
}

Users may pass either the canonical character labels above, or common
\code{stats::family()} objects:
\itemize{
\item \code{stats::binomial(link = "probit")}
\item \code{stats::binomial(link = "logit")}
\item \code{stats::poisson(link = "log")}
}
}
\keyword{internal}
