% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai_assistant.R
\name{goose_explain_error}
\alias{goose_explain_error}
\title{Explain R Error with AI}
\usage{
goose_explain_error(error = NULL, code = NULL, context = NULL)
}
\arguments{
\item{error}{The error object or error message}

\item{code}{Optional code that caused the error}

\item{context}{Optional context about what you were trying to do}
}
\value{
List with explanation and suggested solutions
}
\description{
Get AI-powered explanation and solution for R errors.
}
\examples{
\dontrun{
# Explain last error
tryCatch({
  data.frame(x = 1:3, y = 1:4)
}, error = function(e) {
  explanation <- goose_explain_error(e)
  print(explanation)
})
}
}
