% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{util_recom_mat}
\alias{util_recom_mat}
\title{Util function to generate recom_mat from raw data.
It returens the recombination probability based on Halden's map function}
\usage{
util_recom_mat(in_df, unit = "cM")
}
\arguments{
\item{in_df}{Data frame of raw data. The column names should be "Gene", "Chr" and "cM".}

\item{unit}{Unit of the gene positions. In the current version, it should be "cM".}
}
\value{
util_recom_mat function returns a matrix of recombination probability between each combination of genes.
}
\description{
Util function to generate recom_mat from raw data.
It returens the recombination probability based on Halden's map function
}
\examples{

in_df <- data.frame(Gene = c("g1", "g2", "g3", "g4"),
                    Chr = c("1A", "1B", "2A", "2A"),
                    cM = c(30, 50, 35, 50))

util_recom_mat(in_df)

}
\references{
Haldane (1919) The combination of linkage values, and the calculation of distances between the loci of linked factors.
Journal of Genetics 8: 299-309.
}
