% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_s2a_ndvi}
\alias{get_s2a_ndvi}
\title{Retrieve Sentinel-2-l2a images to compute NDVI}
\usage{
get_s2a_ndvi(
  bbox = NULL,
  place = NULL,
  datetime = c(),
  cloud_cover = 10,
  vege_perc = 0,
  select = "latest",
  method = "first",
  mask = TRUE,
  output_bands = NULL,
  quiet = TRUE
)
}
\arguments{
\item{bbox}{\code{sf}, \code{sfc}, or a numeric vector (xmin, ymin, xmax, ymax)
defining the area of interest. Optional if \code{place} is provided.}

\item{place}{character or vector. (optional) A single line address,
e.g. ("1600 Pennsylvania Ave NW, Washington") or a vector of addresses
(c("Madrid", "Barcelona")).}

\item{datetime}{numeric vector of 2. The time of interest such as
\code{c("2020-08-01", "2020-09-01")}.}

\item{cloud_cover}{numeric. Threshold for the percentage of cloud coverage.
Desfault is 10.}

\item{vege_perc}{numeric. Threshold for the percentage of vegetation coverage.
Desfault is 0.}

\item{select}{character. one of "latest", "earliest", "all". The default
is "latest".}

\item{method}{character. A method for mosaicing layers: one of "mean",
"median", "min", "max", "modal", "sum", "first", "last". The default
is "first".}

\item{mask}{logical (optional). Default is \code{TRUE}. If \code{TRUE}, masks the
raster data using the given \code{bbox} or \code{place}.}

\item{output_bands}{vector. A list of band names (\code{c('B04', 'B08')}).
The default is \code{NULL}. If \code{output_bands} is specified, NDVI will not
be computed and only the specified bands will be returned.
All available bands can be found \href{https://docs.sentinel-hub.com/api/latest/data/sentinel-2-l2a/#available-bands-and-data}{here}}

\item{quiet}{logical. Whether show progress bars for some process.}
}
\value{
A \code{SpatRaster} object containing (multiple) NDVI layer(s) (for different
period of time) \code{select = "latest"} or \code{select = "first"}
(or if \code{mask = TRUE} and \code{select = "all"})

A \code{List} of NDVI rasters if \code{mask = FALSE} and \code{select = "all"}.
}
\description{
download Sentinel-2-l2a imagery data and compute NDVI.
Users can define an area of interest using a bounding box or place name.
}
\examples{
result <- get_s2a_ndvi(
  # place = 'New York',
  datetime = c("2020-08-01", "2020-09-01")
)
}
