\name{expectSampsize}
\alias{expectSampsize}
\title{Expected sample size for a gsearly model}
\usage{expectSampsize(mod, signif=3)}
\description{Calculates the expected sample size for a fitted gsearly model,
 from functions \code{gsearlyModel} or \code{gsearlyUser}.}
\arguments{
 \item{mod}{A gsearly model.}
 \item{signif}{Rounds the sample size to the specified number of significant
   digits.}
}
\value{
 Returns the sample size for the control and treatment groups and total.
}
\seealso{
 \code{\link{gsearlyModel}}, \code{\link{gsearlyUser}}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0010,0.0100,0.0250)
 tn <- c(0.4800,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="fix", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(16,31), pow=0.8, cmodel="exponential", sd=20,
                   rho=0.75, theta=8, fp=fp, tn=tn)
 expectSampsize(rctdesign)

}
