% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{illness}
\alias{illness}
\title{Lab tests for one suffering from an illness}
\format{
A tibble with 39 rows and 11 variables:
\describe{
\item{test}{The name of the test.}
\item{units}{The measurement units for the test.}
\item{day_3,day_4,day_5,day_6,day_7,day_8,day_9}{Measurement values
associated with each test administered from days 3 to 9. An \code{NA} value
indicates that the test could not be performed that day.}
\item{norm_l,norm_u}{Lower and upper bounds for the normal range associated
with the test.}
}
}
\usage{
illness
}
\description{
A dataset with artificial daily lab data for a patient with Yellow Fever
(YF). The table comprises laboratory findings for the patient from day 3 of
illness onset until day 9 (after which the patient died). YF viral DNA was
found in serum samples from day 3, where the viral load reached 14,000 copies
per mL. Several medical interventions were taken to help the patient,
including the administration of fresh frozen plasma, platelets, red cells,
and coagulation factor VIII. The patient also received advanced support
treatment in the form of mechanical ventilation and plasmapheresis. Though
the patient's temperature remained stable during their illness,
unfortunately, the patient's condition did not improve. On days 7 and 8, the
patient's health declined further, with symptoms such as nosebleeds,
gastrointestinal bleeding, and hematoma.
}
\details{
The various tests are identified in the \code{test} column. The following listing
provides the full names of any abbreviations seen in that column.

\itemize{
\item \code{"WBC"}: white blood cells.
\item \code{"RBC"}: red blood cells.
\item \code{"Hb"}: hemoglobin.
\item \code{"PLT"}: platelets.
\item \code{"ALT"}: alanine aminotransferase.
\item \code{"AST"}: aspartate aminotransferase.
\item \code{"TBIL"}: total bilirubin.
\item \code{"DBIL"}: direct bilirubin.
\item \code{"NH3"}: hydrogen nitride.
\item \code{"PT"}: prothrombin time.
\item \code{"APTT"}: activated partial thromboplastin time.
\item \code{"PTA"}: prothrombin time activity.
\item \code{"DD"}: D-dimer.
\item \code{"FDP"}: fibrinogen degradation products.
\item \code{"LDH"}: lactate dehydrogenase.
\item \code{"HBDH"}: hydroxybutyrate dehydrogenase.
\item \code{"CK"}: creatine kinase.
\item \code{"CKMB"}: the MB fraction of creatine kinase.
\item \code{"BNP"}: B-type natriuretic peptide.
\item \code{"MYO"}: myohemoglobin.
\item \code{"TnI"}: troponin inhibitory.
\item \code{"CREA"}: creatinine.
\item \code{"BUN"}: blood urea nitrogen.
\item \code{"AMY"}: amylase.
\item \code{"LPS"}: lipase.
\item \code{"K"}: kalium.
\item \code{"Na"}: sodium.
\item \code{"Cl"}: chlorine.
\item \code{"Ca"}: calcium.
\item \code{"P"}: phosphorus.
\item \code{"Lac"}: lactate, blood.
\item \code{"CRP"}: c-reactive protein.
\item \code{"PCT"}: procalcitonin.
\item \code{"IL-6"}: interleukin-6.
\item \code{"CD3+CD4+"}: CD4+T lymphocytes.
\item \code{"CD3+CD8+"}: CD8+T lymphocytes.
}
}
\section{Dataset ID and Badge}{

DATA-13

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_illness.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.10.0} (October 7, 2023)
}

\examples{
dplyr::glimpse(illness)
}
\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
