% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_engineering}
\alias{fmt_engineering}
\title{Format values to engineering notation}
\usage{
fmt_engineering(
  data,
  columns = everything(),
  rows = everything(),
  decimals = 2,
  drop_trailing_zeros = FALSE,
  drop_trailing_dec_mark = TRUE,
  scale_by = 1,
  exp_style = "x10n",
  pattern = "{x}",
  sep_mark = ",",
  dec_mark = ".",
  force_sign_m = FALSE,
  force_sign_n = FALSE,
  locale = NULL
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to target}

\code{\link[=rows-columns]{<column-targeting expression>}} // \emph{default:} \code{everything()}

Can either be a series of column names provided in \code{c()}, a vector of
column indices, or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}} and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\code{\link[=rows-columns]{<row-targeting expression>}} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
undergo formatting. The default \code{\link[=everything]{everything()}} results in all rows in
\code{columns} being formatted. Alternatively, we can supply a vector of row
captions within \code{c()}, a vector of row indices, or a select helper
function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{decimals}{\emph{Number of decimal places}

\code{scalar<numeric|integer>(val>=0)} // \emph{default:} \code{2}

This corresponds to the exact number of decimal places to use. A value
such as \code{2.34} can, for example, be formatted with \code{0} decimal places and
it would result in \code{"2"}. With \code{4} decimal places, the formatted value
becomes \code{"2.3400"}.}

\item{drop_trailing_zeros}{\emph{Drop any trailing zeros}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

A logical value that allows for removal of trailing zeros (those redundant
zeros after the decimal mark).}

\item{drop_trailing_dec_mark}{\emph{Drop the trailing decimal mark}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

A logical value that determines whether decimal marks should always appear
even if there are no decimal digits to display after formatting (e.g., \code{23}
becomes \code{23.} if \code{FALSE}). By default trailing decimal marks are not shown.}

\item{scale_by}{\emph{Scale values by a fixed multiplier}

\verb{scalar<numeric|integer>} // \emph{default:} \code{1}

All numeric values will be multiplied by the \code{scale_by} value before
undergoing formatting. Since the \code{default} value is \code{1}, no values will be
changed unless a different multiplier value is supplied.}

\item{exp_style}{\emph{Style declaration for exponent formatting}

\verb{scalar<character>} // \emph{default:} \code{"x10n"}

Style of formatting to use for the scientific notation formatting. By
default this is \code{"x10n"} but other options include using a single letter
(e.g., \code{"e"}, \code{"E"}, etc.), a letter followed by a \code{"1"} to signal a
minimum digit width of one, or \code{"low-ten"} for using a stylized \code{"10"}
marker.}

\item{pattern}{\emph{Specification of the formatting pattern}

\verb{scalar<character>} // \emph{default:} \code{"{x}"}

A formatting pattern that allows for decoration of the formatted value. The
formatted value is represented by the \code{{x}} (which can be used multiple
times, if needed) and all other characters will be interpreted as string
literals.}

\item{sep_mark}{\emph{Separator mark for digit grouping}

\verb{scalar<character>} // \emph{default:} \code{","}

The string to use as a separator between groups of digits. For example,
using \code{sep_mark = ","} with a value of \code{1000} would result in a formatted
value of \code{"1,000"}. This argument is ignored if a \code{locale} is supplied
(i.e., is not \code{NULL}).}

\item{dec_mark}{\emph{Decimal mark}

\verb{scalar<character>} // \emph{default:} \code{"."}

The string to be used as the decimal mark. For example, using
\code{dec_mark = ","} with the value \code{0.152} would result in a formatted value
of \code{"0,152"}). This argument is ignored if a \code{locale} is supplied (i.e., is
not \code{NULL}).}

\item{force_sign_m, force_sign_n}{\emph{Forcing the display of a positive sign}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Should the plus sign be shown for positive values of the mantissa (first
component, \code{force_sign_m}) or the exponent (\code{force_sign_n})? This would
effectively show a sign for all values except zero on either of those
numeric components of the notation. If so, use \code{TRUE} for either one of
these options. The default for both is \code{FALSE}, where only negative numbers
will display a sign.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for formatting values
according to the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can call \code{\link[=info_locales]{info_locales()}} for a
useful reference for all of the locales that are supported. A locale ID can
be also set in the initial \code{\link[=gt]{gt()}} function call (where it would be used
automatically by any function with a \code{locale} argument) but a \code{locale}
value provided here will override that global locale.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
With numeric values in a \strong{gt} table, we can perform formatting so that the
targeted values are rendered in engineering notation, where numbers are
written in the form of a mantissa (\code{m}) and an exponent (\code{n}). When combined
the construction is either of the form \emph{m} x 10^\emph{n} or \emph{m}E\emph{n}. The mantissa
is a number between \code{1} and \code{1000} and the exponent is a multiple of \code{3}. For
example, the number 0.0000345 can be written in engineering notation as
\verb{34.50 x 10^-6}. This notation helps to simplify calculations and make it
easier to compare numbers that are on very different scales.

We have fine control over the formatting task, with the following options:
\itemize{
\item decimals: choice of the number of decimal places, option to drop
trailing zeros, and a choice of the decimal symbol
\item scaling: we can choose to scale targeted values by a multiplier value
\item pattern: option to use a text pattern for decoration of the formatted
values
\item locale-based formatting: providing a locale ID will result in
formatting specific to the chosen locale
}
}
\section{Compatibility of formatting function with data values}{


\code{fmt_engineering()} is compatible with body cells that are of the
\code{"numeric"} or \code{"integer"} types. Any other types of body cells are ignored
during formatting. This is to say that cells of incompatible data types may
be targeted, but there will be no attempt to format them.
}

\section{Compatibility of arguments with the \code{from_column()} helper function}{


\code{\link[=from_column]{from_column()}} can be used with certain arguments of \code{fmt_engineering()} to
obtain varying parameter values from a specified column within the table.
This means that each row could be formatted a little bit differently. These
arguments provide support for \code{\link[=from_column]{from_column()}}:
\itemize{
\item \code{decimals}
\item \code{drop_trailing_zeros}
\item \code{drop_trailing_dec_mark}
\item \code{scale_by}
\item \code{exp_style}
\item \code{pattern}
\item \code{sep_mark}
\item \code{dec_mark}
\item \code{force_sign_m}
\item \code{force_sign_n}
\item \code{locale}
}

Please note that for all of the aforementioned arguments, a \code{\link[=from_column]{from_column()}}
call needs to reference a column that has data of the correct type (this is
different for each argument). Additional columns for parameter values can be
generated with \code{\link[=cols_add]{cols_add()}} (if not already present). Columns that contain
parameter data can also be hidden from final display with \code{\link[=cols_hide]{cols_hide()}}.
Finally, there is no limitation to how many arguments the \code{\link[=from_column]{from_column()}}
helper is applied so long as the arguments belong to this closed set.
}

\section{Adapting output to a specific \code{locale}}{


This formatting function can adapt outputs according to a provided \code{locale}
value. Examples include \code{"en"} for English (United States) and \code{"fr"} for
French (France). The use of a valid locale ID here means separator and
decimal marks will be correct for the given locale. Should any values be
provided in \code{sep_mark} or \code{dec_mark}, they will be overridden by the locale's
preferred values.

Note that a \code{locale} value provided here will override any global locale
setting performed in \code{\link[=gt]{gt()}}'s own \code{locale} argument (it is settable there as
a value received by all other functions that have a \code{locale} argument). As a
useful reference on which locales are supported, we can call \code{\link[=info_locales]{info_locales()}}
to view an info table.
}

\section{Examples}{


Let's define a data frame that contains two columns of values (one \code{small}
and one \code{large}). After creating a simple \strong{gt} table from \code{small_large_tbl}
we'll call \code{fmt_engineering()} on both columns.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{small_large_tbl <-
  dplyr::tibble(
    small = 10^(-12:-1),
    large = 10^(1:12)
  )

small_large_tbl |>
  gt() |>
  fmt_engineering()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_engineering_1.png" alt="This image of a table was generated from the first code example in the `fmt_engineering()` help file." style="width:100\%;">
}}

Notice that within the form of \emph{m} x 10^\emph{n}, the \emph{n} values move in steps of
3 (away from \code{0}), and \emph{m} values can have 1-3 digits before the decimal.
Further to this, any values where \emph{n} is \code{0} results in a display of only \emph{m}
(the first two values in the \code{large} column demonstrates this).

Engineering notation expresses values so that they are align to certain SI
prefixes. Here is a table that compares select SI prefixes and their symbols
to decimal and engineering-notation representations of the key numbers.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{prefixes_tbl <-
  dplyr::tibble(
    name = c(
      "peta", "tera", "giga", "mega", "kilo",
      NA,
      "milli", "micro", "nano", "pico", "femto"
    ),
    symbol = c(
      "P", "T", "G", "M", "k",
      NA,
      "m", ":micro:", "n", "p", "f"
    ),
    decimal = c(10^(seq(15, -15, -3))),
    engineering = decimal
  )

prefixes_tbl |>
  gt() |>
  fmt_number(columns = decimal, n_sigfig = 1) |>
  fmt_engineering(columns = engineering) |>
  fmt_units(columns = symbol) |>
  sub_missing()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_engineering_2.png" alt="This image of a table was generated from the second code example in the `fmt_engineering()` help file." style="width:100\%;">
}}

The default method of styling the notation uses the '\emph{m} x 10^\emph{n}'
construction but this can be changed to a '\emph{m}E\emph{n}' style via the \code{exp_style}
argument. We can supply any single letter here and optionally affix a \code{"1"}
to indicate there should not be any zero-padding of the \emph{n} value. Two calls
of \code{fmt_engineering()} are used here to show different options for styling
in engineering notation.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{small_large_tbl |>
  gt() |>
  fmt_engineering(
    columns = small,
    exp_style = "E"
  ) |>
  fmt_engineering(
    columns = large,
    exp_style = "e1",
    force_sign_n = TRUE
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_engineering_3.png" alt="This image of a table was generated from the third code example in the `fmt_engineering()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-4
}

\section{Function Introduced}{

\code{v0.3.1} (August 9, 2021)
}

\seealso{
The vector-formatting version of this function:
\code{\link[=vec_fmt_engineering]{vec_fmt_engineering()}}.

Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt}()},
\code{\link{fmt_auto}()},
\code{\link{fmt_bins}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_chem}()},
\code{\link{fmt_country}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_date}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_email}()},
\code{\link{fmt_flag}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_icon}()},
\code{\link{fmt_image}()},
\code{\link{fmt_index}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_number_si}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_spelled_num}()},
\code{\link{fmt_tf}()},
\code{\link{fmt_time}()},
\code{\link{fmt_units}()},
\code{\link{fmt_url}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()}
}
\concept{data formatting functions}
