% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_roman}
\alias{vec_fmt_roman}
\title{Format a vector as Roman numerals}
\usage{
vec_fmt_roman(
  x,
  case = c("upper", "lower"),
  pattern = "{x}",
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{\emph{The input vector}

\code{vector(numeric|integer)} // \strong{required}

This is the input vector that will undergo transformation to a character
vector of the same length. Values within the vector will be formatted.}

\item{case}{\emph{Use uppercase or lowercase letters}

\verb{singl-kw:[upper|lower]} // \emph{default:} \code{"upper"}

Should Roman numerals should be rendered as uppercase (\code{"upper"}) or
lowercase (\code{"lower"}) letters? By default, this is set to \code{"upper"}.}

\item{pattern}{\emph{Specification of the formatting pattern}

\verb{scalar<character>} // \emph{default:} \code{"{x}"}

A formatting pattern that allows for decoration of the formatted value. The
formatted value is represented by the \code{{x}} (which can be used multiple
times, if needed) and all other characters will be interpreted as string
literals.}

\item{output}{\emph{Output format}

\verb{singl-kw:[auto|plain|html|latex|rtf|word]} // \emph{default:} \code{"auto"}

The output style of the resulting character vector. This can either be
\code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"}, or
\code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the \code{"auto"}
option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
With numeric values in a vector, we can transform those to Roman numerals,
rounding values as necessary.
}
\section{Examples}{


Let's create a numeric vector for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{num_vals <- c(1, 4, 5, 8, 12, 20, 0, -5, 1.3, NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_roman()} with the default options will create a character
vector with values rendered as Roman numerals. Zero values will be rendered
as \code{"N"}, any \code{NA} values remain as \code{NA} values, negative values will be
automatically made positive, and values greater than or equal to 3900 will be
rendered as \code{"ex terminis"}. The rendering context will be autodetected
unless specified in the \code{output} argument (here, it is of the \code{"plain"}
output type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_roman(num_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "I" "IV" "V" "VIII" "XII" "XX" "N" "V" "I" "NA"
}\if{html}{\out{</div>}}

We can also use \code{vec_fmt_roman()} with the \code{case = "lower"} option to create
a character vector with values rendered as lowercase Roman numerals.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_roman(num_vals, case = "lower")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "i" "iv" "v" "viii" "xii" "xx" "n" "v" "i" "NA"
}\if{html}{\out{</div>}}

As a last example, one can wrap the values in a pattern with the \code{pattern}
argument. Note here that \code{NA} values won't have the pattern applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_roman(num_vals, case = "lower", pattern = "\{x\}.")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "i." "iv." "v." "viii." "xii." "xx." "n." "v." "i." "NA"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

15-10
}

\section{Function Introduced}{

\code{v0.8.0} (November 16, 2022)
}

\seealso{
The variant function intended for formatting \strong{gt} table data:
\code{\link[=fmt_roman]{fmt_roman()}}.

Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_index}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_number_si}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_spelled_num}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
