% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_tables.R
\name{info_icons}
\alias{info_icons}
\title{View a table with all available Font Awesome icons for \code{fmt_icon()}}
\usage{
info_icons()
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{\link[=fmt_icon]{fmt_icon()}} can be used to render \emph{Font Awesome} icons within
body cells that reference the icon names. Further to this, the text
transformation functions (e.g., \code{\link[=text_case_match]{text_case_match()}}) allow for the insertion
of these icons as replacement text (so long as you use the \code{fa()} function
from the \strong{fontawesome} package). Because there is a very large number of
icons available to use in \emph{Font Awesome}, \code{info_icons()} can be used to
provide us with a table that lists all the icons along with their short and
full names (either can be used with \code{\link[=fmt_icon]{fmt_icon()}}). It also contains
acceptable codes for \code{\link[=fmt_country]{fmt_country()}}
}
\section{Examples}{


Get a table of info on all the available \emph{Font Awesome} icons.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_icons()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_icons_1.png" alt="This image of a table was generated from the first code example in the `info_icons()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

11-9
}

\section{Function Introduced}{

\code{v0.10.0} (October 7, 2023)
}

\seealso{
Other information functions: 
\code{\link{info_currencies}()},
\code{\link{info_date_style}()},
\code{\link{info_flags}()},
\code{\link{info_google_fonts}()},
\code{\link{info_locales}()},
\code{\link{info_paletteer}()},
\code{\link{info_tf_style}()},
\code{\link{info_time_style}()},
\code{\link{info_unit_conversions}()}
}
\concept{information functions}
