% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_adj.R
\name{group_adj}
\alias{group_adj}
\title{Group Level Adjustment That Accounts for Propensity to Guess}
\usage{
group_adj(pre = NULL, pst = NULL, gamma = NULL, dk = 0.03)
}
\arguments{
\item{pre}{pre data frame. Required. Each vector within the data frame should only take values 0, 1, and 'd'.}

\item{pst}{pst data frame. Required. Each vector within the data frame should only take values 0, 1, and 'd'.}

\item{gamma}{probability of getting the right answer without knowledge}

\item{dk}{Numeric. Between 0 and 1. Hidden knowledge behind don't know responses. Default is .03.}
}
\value{
nested list of pre and post adjusted responses, and adjusted learning estimates
}
\description{
Adjusts observed 1s based on propensity to guess (based on observed 0s) and item level \eqn{\gamma}. 
You can also put in your best estimate of hidden knowledge behind don't know responses.
}
\examples{
pre_test_var <- data.frame(pre = c(1,0,0,1,"d","d",0,1,NA))
pst_test_var <- data.frame(pst = c(1,NA,1,"d",1,0,1,1,"d"))
gamma <- c(.25)
group_adj(pre_test_var, pst_test_var, gamma)
}
