% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanc_ml.R
\name{hanc_ml}
\alias{hanc_ml}
\title{Anomaly detector based on ML classification}
\usage{
hanc_ml(model, threshold = 0.5)
}
\arguments{
\item{model}{A DALToolbox classification model.}

\item{threshold}{Numeric. Probability threshold for positive class.}
}
\value{
\code{hanc_ml} object.
}
\description{
Supervised anomaly detection using a DALToolbox classifier trained with
labeled events. Predictions above a probability threshold are flagged.

A set of preconfigured classification methods are listed at
\url{https://cefet-rj-dal.github.io/daltoolbox/} (e.g., \code{cla_majority},
\code{cla_dtree}, \code{cla_knn}, \code{cla_mlp}, \code{cla_nb}, \code{cla_rf}, \code{cla_svm}).
}
\examples{
library(daltoolbox)

# Load labeled anomaly dataset
data(examples_anomalies)

# Use train-test example
dataset <- examples_anomalies$tt
dataset$event <- factor(dataset$event, labels=c("FALSE", "TRUE"))
slevels <- levels(dataset$event)

# Split into training and test
train <- dataset[1:80,]
test <- dataset[-(1:80),]

# Normalize features
norm <- minmax()
norm <- fit(norm, train)
train_n <- daltoolbox::transform(norm, train)

# Configure a decision tree classifier
model <- hanc_ml(cla_dtree("event", slevels))

# Fit the classifier
model <- fit(model, train_n)

# Evaluate detections on the test set
test_n <- daltoolbox::transform(norm, test)

detection <- detect(model, test_n)
print(detection[(detection$event),])

}
\references{
\itemize{
\item Bishop CM (2006). Pattern Recognition and Machine Learning. Springer.
\item Hyndman RJ, Athanasopoulos G (2021). Forecasting: Principles and Practice. OTexts.
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
