% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqTab.R
\name{freqTab}
\alias{freqTab}
\title{A tibble containing sample sequence frequencies and estimated probabilities}
\usage{
freqTab(S, j = NULL, A, countsTab, complete = TRUE)
}
\arguments{
\item{S}{A numeric vector of positive integers or \code{NULL}. Represents a set
of past lags that must be present within the columns of the \code{countsTab}
argument and are to be considered while estimating the transition probabilities.
Both \code{S} and \code{j} cannot be \code{NULL} at the same time.}

\item{j}{An integer or \code{NULL}. Typically represents a lag \code{j} in the
\eqn{complement} of \code{S}. Both \code{S} and \code{j} cannot be \code{NULL}
at the same time. See \emph{Details} for further information.}

\item{A}{A vector with nonnegative integers. Must have at least two different entries.
\code{A} represents the state space.}

\item{countsTab}{A tibble or a data frame with all sequences of length d+1 that
appear in the sample, and their absolute frequency. This tibble is typically
generated by the function \code{\link[=countsTab]{countsTab()}}. If using a custom data frame not
generated by \code{\link[=countsTab]{countsTab()}}, make sure its format and column names match the
expected structure; otherwise, errors may occur in \code{\link[=freqTab]{freqTab()}}.}

\item{complete}{Logical. If \code{TRUE} all sequences that did not appear in the
sample will be included in the output with frequency equal to 0.}
}
\value{
A tibble where each row represents a sequence of elements from \code{A}.
The initial columns display each sequence symbol separated into columns
corresponding to their time indexes. The remaining columns show the sample
frequencies of the sequences and the MLE (Maximum Likelihood Estimator)
of the transition probabilities.
}
\description{
This function returns a tibble containing the sample sequences, their frequencies
and the estimated transition probabilities.
}
\details{
The parameters \code{S} and \code{j} determine which columns of \code{countsTab}
are retained in the output. Specifying a lag \code{j} is optional. All lags can
be specified via \code{S}, while leaving \code{j = NULL} (default). The output
remains the same as when specifying \code{S} and \code{j} separately. The
inclusion of \code{j} as a parameter improves clarity within the package's
algorithms. Note that \code{j} cannot be an element of \code{S}.
}
\examples{
# Reproducible simulated data
set.seed(1)
M <- MTDmodel(Lambda = c(1, 4), A = c(1, 2, 3), lam0 = 0.1)
X <- perfectSample(M, N = 400)
ct <- countsTab(X, d = 5)

# Example with S non-empty and j specified
freqTab(S = c(1, 4), j = 2, A = c(1, 2, 3), countsTab = ct)

# Equivalent to calling with S = c(1,2,4) and j = NULL
freqTab(S = c(1, 2, 4), j = NULL, A = c(1, 2, 3), countsTab = ct)

}
