% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_mcm.R
\name{auc_mcm}
\alias{auc_mcm}
\title{AUC for cure prediction using mean score imputation}
\usage{
auc_mcm(object, newdata, cure_cutoff = 5, model_select = "AIC")
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs},
\code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.}

\item{newdata}{an optional data.frame that minimally includes the incidence
and/or latency variables to use for predicting the response. If omitted, the
training data are used.}

\item{cure_cutoff}{cutoff value for cure, used to produce a proxy for the
unobserved cure status (default is 5 representing 5 years). Users
should be careful to note the time scale of their data and adjust this
according to the time scale and clinical application.}

\item{model_select}{either a case-sensitive parameter for models fit using
\code{curegmifs} or \code{cureem} or any numeric step along the solution path
can be selected. The default is \code{model_select = "AIC"} which calculates
the predicted values using the coefficients from the model achieving the
minimum AIC. The complete list of options are:
\itemize{
\item \code{"AIC"} for the minimum AIC (default).
\item \code{"mAIC"} for the minimum modified AIC.
\item \code{"cAIC"} for the minimum corrected AIC.
\item \code{"BIC"}, for the minimum BIC.
\item \code{"mBIC"} for the minimum modified BIC.
\item \code{"EBIC"} for the minimum extended BIC.
\item \code{"logLik"} for the step that maximizes the
log-likelihood.
\item \code{n} where n is any numeric value from the
solution path.
}
This option has no effect for objects fit using \code{cv_curegmifs} or
\code{cv_cureem}.}
}
\value{
Returns the AUC value for cure prediction using the mean score
imputation (MSI) method.
}
\description{
This function calculates the AUC for cure prediction using the mean score
imputation (MSI) method proposed by Asano et al (2014).
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
testing <- temp$testing
fit <- curegmifs(Surv(Time, Censor) ~ .,
  data = training, x_latency = training,
  model = "weibull", thresh = 1e-4, maxit = 2000,
  epsilon = 0.01, verbose = FALSE
)
auc_mcm(fit, model_select = "cAIC")
auc_mcm(fit, newdata = testing)
}
\references{
Asano, J., Hirakawa, H., Hamada, C. (2014) Assessing the
prediction accuracy of cure in the Cox proportional hazards cure model:
an application to breast cancer data. \emph{Pharmaceutical Statistics},
\bold{13}:357--363.
}
\seealso{
\code{\link{concordance_mcm}}
}
\keyword{univar}
