% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiexpose.R
\name{multiexpose}
\alias{multiexpose}
\title{Aggregate health impacts from multiple exposures}
\usage{
multiexpose(
  output_attribute_exp_1,
  output_attribute_exp_2,
  exp_name_1,
  exp_name_2,
  approach_multiexposure = "additive"
)
}
\arguments{
\item{output_attribute_exp_1, output_attribute_exp_2}{Output of attribute() for exposure 1 and 2, respectively. Baseline health data and population must be identical in outputs 1 and 2.}

\item{exp_name_1, exp_name_2}{\code{String} referring to the name of the environmental exposures 1 and 2}

\item{approach_multiexposure}{\code{String} specifying the multiple exposures approach to be used in the assessment. Options: "additive" (default), "multiplicative" or "combined".}
}
\value{
This function returns a \code{list} containing:

1) \code{health_main} (\code{tibble}) containing the main results;
\itemize{
 \item \code{impact} (\code{numeric} column) attributable health burden/impact
 \item \code{pop_fraction} (\code{numeric} column) population attributable fraction; only applicable in relative risk assessments
 \item And many more
}

2) \code{health_detailed} (\code{list}) containing detailed (and interim) results.
\itemize{
 \item \code{input_args} (\code{list}) containing all the argument inputs used in the background
 \item \code{input_table} (\code{tibble}) containing the inputs after preparation
 \item \code{results_raw} (\code{tibble}) containing results for all combinations of input (geo units, uncertainty, age and sex specific data...)
 \item \code{results_by_...} (\code{tibble}) containing results stratified by each geographic unit, age or sex.


}
}
\description{
This function aggregates health impacts from multiple exposures to environmental stressors.
}
\details{
\strong{Methodology}

This function can add up the attributable health impacts from correlated exposures
applying one of the following methods \insertCite{Strak2024_report}{healthiar}:
\itemize{
 \item Additive \insertCite{Steenland2006-e}{healthiar}
 \item Multiplicative \insertCite{Jerrett2013-oup}{healthiar}
 \item Combined \insertCite{Steenland2006-e}{healthiar}
 }

Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#two-correlated-exposures}{Two correlated exposures}}
}
\examples{
# Goal: determine aggregated health impacts from multiple exposures
# Step 1: create assessment with exposure 1
output_attribute_exp_1 <- attribute_health(
  erf_shape = "log_linear",
  rr_central = 1.369,
  rr_increment = 10,
  exp_central = 8.85,
  cutoff_central = 5,
  bhd_central = 30747
)
output_attribute_exp_1$health_main$impact
# Step 2: create assessment with exposure 2
output_attribute_exp_2 <- attribute_mod(
  output_attribute = output_attribute_exp_1,
  exp_central = 10.9,
  rr_central = 1.031
)
output_attribute_exp_2$health_main$impact
# Step 3: aggregate impacts of the two assessments
results <- multiexpose(
  output_attribute_exp_1 = output_attribute_exp_1,
  output_attribute_exp_2 = output_attribute_exp_2,
  exp_name_1 = "pm2.5",
  exp_name_2 = "no2",
  approach_multiexposure = "multiplicative"
)
results$health_main$impact


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream: \code{\link{attribute_health}}, \code{\link{attribute_lifetable}}
}
}
\author{
Alberto Castro & Axel Luyten
}
