% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pot_estimator.r
\name{gpd_lg_likelihood}
\alias{gpd_lg_likelihood}
\title{Negative Log likelihood of Generalized Pareto Distribution}
\usage{
gpd_lg_likelihood(params, data)
}
\arguments{
\item{params}{Vector containing initial values of \eqn{\xi} and \eqn{\beta}}

\item{data}{Original dataset}
}
\value{
Negative log-likelihood of the GPD.
}
\description{
Helper function for pot_estimator(). Returns the \eqn{\xi} and \eqn{\beta} that minimize the negative log-likelihood of the Generalized Pareto Distribution (GPD).
}
\details{
\deqn{l(\xi,\beta)=-n\log(\beta) - (\frac{1}{\xi} + 1)\sum_{i=1}^{n}  \log(1 + \xi \frac{x_i}{\beta})}
}
\examples{

x <- rweibull(n=2000, shape = 0.8, scale = 1)
u <- 2 # Threshold
y <- x[x > u] - u
log_lik <- gpd_lg_likelihood(params = c(xi = 0.1, beta = 2), data = y)


}
