% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_points.R
\name{createLabelDFTemplate}
\alias{createLabelDFTemplate}
\title{Create a label data frame}
\usage{
createLabelDFTemplate(
  df,
  xCol = 1,
  yCol = 2,
  labeledPoints = NULL,
  labelOutside = FALSE,
  labXThr = NULL,
  labYThr = NULL,
  adjFunX = identity,
  adjFunY = identity,
  compFunX = `>=`,
  compFunY = `>=`
)
}
\arguments{
\item{df}{A data frame.}

\item{xCol}{Column representing the \code{x} axis.}

\item{yCol}{Column representing the \code{y} axis.}

\item{labeledPoints}{Point labels to be displayed on the plot. Default is
\code{NULL}, entailing that point labels will be displayed on the basis
of \code{labXThr} and \code{labYThr}, if at least one of them is not
\code{NULL}.}

\item{labelOutside}{Display labels for points specified by
\code{labeledPoints} even if they fall outside the boundaries imposed by
\code{labXThr} and \code{labYThr}. Ignored if \code{labeledPoints} is
\code{NULL} or both \code{labXThr} and \code{labYThr} are \code{NULL}.}

\item{labXThr}{Threshold used to plot labels based on \code{xCol} values.}

\item{labYThr}{Threshold used to plot labels based on \code{yCol} values.}

\item{adjFunX}{Function used to adjust \code{xCol} values. Default is
\code{identity} (no adjustment will be performed).}

\item{adjFunY}{Function used to adjust \code{yCol} values. Default is
\code{identity} (no adjustment will be performed).}

\item{compFunX}{Function used for the selection of \code{xCol} values
based on \code{labXThr}.}

\item{compFunY}{Function used for the selection of \code{yCol} values
based on \code{labYThr}.}
}
\value{
A label data frame.
}
\description{
This function creates a label data frame to be used by plotting functions
that label selected points.
}
\keyword{internal}
