% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_dependency.R
\name{copyDependencyToDir}
\alias{copyDependencyToDir}
\title{Copy an HTML dependency to a directory}
\usage{
copyDependencyToDir(dependency, outputDir, mustWork = TRUE)
}
\arguments{
\item{dependency}{A single HTML dependency object.}

\item{outputDir}{The directory in which a subdirectory should be created for
this dependency.}

\item{mustWork}{If \code{TRUE} and \code{dependency} does not point to a
directory on disk (but rather a URL location), an error is raised. If
\code{FALSE} then non-disk dependencies are returned without modification.}
}
\value{
The dependency with its \code{src} value updated to the new
location's absolute path.
}
\description{
Copies an HTML dependency to a subdirectory of the given directory. The
subdirectory name will be \emph{name}-\emph{version} (for example,
"outputDir/jquery-1.11.0"). You may set \code{options(htmltools.dir.version = FALSE)} to suppress the version number in the subdirectory name.
}
\details{
In order for disk-based dependencies to work with static HTML files, it's
generally necessary to copy them to either the directory of the referencing
HTML file, or to a subdirectory of that directory. This function makes it
easier to perform that copy.
}
\seealso{
\code{\link[=makeDependencyRelative]{makeDependencyRelative()}} can be used with the returned
value to make the path relative to a specific directory.
}
