% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{renderDocument}
\alias{renderDocument}
\title{Render an html_document object}
\usage{
renderDocument(x, deps = NULL, processDep = identity)
}
\arguments{
\item{x}{An object of class \code{html_document}, typically generated by the
\code{\link[=htmlTemplate]{htmlTemplate()}} function.}

\item{deps}{Any extra web dependencies to add to the html document. This can
be an object created by \code{\link[=htmlDependency]{htmlDependency()}}, or a list of such
objects. These dependencies will be added first, before other dependencies.}

\item{processDep}{A function that takes a "raw" html_dependency object and
does further processing on it. For example, when \code{renderDocument} is
called from Shiny, the function \code{\link[shiny:createWebDependency]{shiny::createWebDependency()}} is
used; it modifies the href and tells Shiny to serve a particular path on
the filesystem.}
}
\value{
An \code{\link[=HTML]{HTML()}} string, with UTF-8 encoding.
}
\description{
This function renders \code{html_document} objects, and returns a string with
the final HTML content. It calls the \code{\link[=renderTags]{renderTags()}} function to
convert any shiny.tag objects to HTML. It also finds any any web dependencies
(created by \code{\link[=htmlDependency]{htmlDependency()}}) that are attached to the tags, and
inserts those. To do the insertion, this function finds the string
\code{"<!-- HEAD_CONTENT -->"} in the document, and replaces it with the web
dependencies.
}
