% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eb.R
\docType{data}
\name{eb}
\alias{eb}
\title{Eclipsing Binaries (Beta Lyrae)}
\format{
A data frame with 470 observations on the following 3 variables:
\describe{
  \item{t}{heliocentric Julian Day}
  \item{m}{magnitude}
  \item{merr}{measurement error of the magnitude (in mag).}
}
}
\usage{
eb
}
\description{
Time series of a Beta Lyrae variable star obtained from OGLE.
}
\details{
The frequency computed by GLS for this light curve is 1.510571586.
Catalogs and designations of this star:OGLE051951.22-694002.7
}
\examples{
data(eb)
f1=1.510571586
o1=iAR::utilities()
o1<-phase(o1,data=eb,f1=f1,twop=TRUE)
plot(o1@times_phased,o1@series_phased,pch=20)
}
\keyword{datasets}
