% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_harmonicfit.R
\name{harmonicfit}
\alias{harmonicfit}
\title{Harmonic Fit to Time Series}
\usage{
harmonicfit(x, ...)
}
\arguments{
\item{x}{An object of class `utilities`.}

\item{...}{Additional arguments for pairing time series:
\describe{
  \item{data}{A data frame with three columns corresponding to the time, values, and standard errors of the irregularly observed time series.}
  \item{f1}{frequency (1 / period) of the time series.}
  \item{nham}{Number of harmonic components in the model.}
  \item{weighted}{logical; if true, a weighted least squares (WLS) estimation is performed using weights based on the standard deviations of the errors. Default is 'FALSE'.}
  \item{remove_trend}{logical; if true, the linear trend of time series will be removed before the the harmonic model is fitted.}
 }}
}
\value{
An object of class `utilities` with the slots:
\item{fitted_values}{Fitted values from the harmonic model.}
\item{residuals}{Residuals from the harmonic model.} 
\item{coef}{Estimated coefficients of the harmonic model.}
\item{summary}{A summary object containing detailed model information.}
}
\description{
This function fit an k-harmonic function to time series data.
}
\details{
The function fits a harmonic regression model with 'nham' components to the input time series, optionally removing a linear trend and allowing for weighted estimation when standard errors are available.
}
\examples{
data(clcep)
f1=0.060033386
o1=iAR::utilities()
o1<-phase(o1,data=clcep,f1=f1)
#results$R2
#results$MSE
#results=harmonicfit(file=clcep[,1:2],f1=f1,nham=3)
#results$R2
#results$MSE
#results=harmonicfit(file=clcep[,1:2],f1=f1,weights=clcep[,3])
#results$R2
#results$MSE
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
