

perm_test<-function(dataset,ry, rind,rtype,nperm=100,parallel=TRUE,
                    workers=15,
                    future_seed=123,progress=TRUE){
  
  dades<- data.frame(dataset) |> dplyr::select(any_of(c(ry,rind,rtype)))
  
  dades <- dades |> dplyr::rename(y = all_of(ry),
                                  ind = all_of(rind),
                                  type = all_of(rtype))
  
  
  mod_orig<-fit_model_dep_icc(dades,"y","ind","type")
  iccest_orig<-icc_est_dep(mod_orig)
  
  
  k <- length(iccest_orig) # mida del vector
  
  icc<-diag(iccest_orig$ICC)
  comb <- combn(icc, 2)  # totes les parelles (i < j)
  dif_r<-apply(comb,2,diff)
  theta_r<-sum(dif_r^2)
  
  
  if(parallel){
    ncores <- parallelly::availableCores(omit = 1)
    if(workers >= ncores){
      workers <- ncores
    }
    
    
    oplan <- future::plan("multisession", workers = workers)
    on.exit(future::plan(oplan))
  }
  
  
  if(progress){
    with_progress({
      
      p <- progressr::progressor(steps = nperm)  
      
      perm_theta<-furrr::future_map(as.integer(1:nperm), ~ {
        p()
        Sys.sleep(.2)
        perm_fun(dades)
      }
      , .options = furrr::furrr_options(seed = future_seed),
      p = p
      )
      
      
    },enable=TRUE)
    
  }else{
    perm_theta<-furrr::future_map(as.integer(1:nperm), ~ {
      perm_fun(dades)
    }
    , .options = furrr::furrr_options(seed = future_seed)
    )
  }
  
  perm_theta<-unlist(perm_theta)
  n_r<-length(remove.NA(perm_theta))
  pval_r<-(sum(ifelse(abs(perm_theta)>=abs(theta_r),1,0),na.rm=TRUE)+1)/(n_r+1)
  
  
  return(list(pval=pval_r,theta_perm=perm_theta,theta_r=theta_r))
  
}


perm_fun<-function(data){
  
  per_sam<-data %>% arrange(ind)
  
  k_ind<-per_sam |> dplyr::group_by(ind,type) |> dplyr::summarise(n=n(),.groups="drop")
  
  k_ind <- k_ind |> dplyr::group_by(ind) |> dplyr::mutate(type_perm=sample(type))
  
  per_sam$type<-rep(k_ind$type_perm,times=k_ind$n)
  
  mod_perm<-fit_model_dep_icc(per_sam,"y","ind","type",warnings=FALSE)
  
  if(inherits(mod_perm,"lme")){
    iccest_perm<-icc_est_dep(mod_perm)

    icc<-diag(iccest_perm$ICC)
    comb <- combn(icc, 2)  # totes les parelles (i < j)
    dif_perm<-apply(comb,2,diff)
    theta_perm<-sum(dif_perm^2)
    
  }
  
  if((inherits(mod_perm,"try-error"))|(is.null(mod_perm))){
    theta_perm<-NA
  }
  
  
  return(theta_perm)
}  


