% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_metadata_read.R
\name{read_metadata}
\alias{read_metadata}
\title{Load and Validate Metadata Table for Immune Repertoire Files}
\usage{
read_metadata(metadata, filename_col = "File", delim = "\\t", ...)
}
\arguments{
\item{metadata}{A metadata table. Can be either:
\itemize{
\item a data frame with metadata,
\item or a path to a text/TSV/CSV file that can be read with \code{readr::read_delim}.
}}

\item{filename_col}{A string specifying the name of the column in the metadata table
that contains paths to repertoire files. Defaults to \code{"File"}.}

\item{delim}{Delimiter used to read the metadata file (if a path is provided). Defaults to \code{"\\t"}.}

\item{...}{Additional arguments passed to \code{readr::read_delim()} when reading metadata from a file.}
}
\value{
A validated and updated metadata data frame with absolute file paths,
and an additional column renamed according to \code{IMD_GLOBALS$schema$filename}.
}
\description{
This function loads a metadata table from either a file path or a data frame,
validates the presence of a column with repertoire file paths, and converts all
file paths to absolute paths. It is used to support flexible pipelines for
loading bulk or single-cell immune repertoire data across samples.

If the input is a file path, the function attempts to read it with \code{readr::read_delim}.
If the input is a data frame, it checks whether file paths are absolute;
relative paths are only allowed when metadata is loaded from a file.

It warns the user if many of the files listed in the metadata table are missing,
and stops execution if none of the files exist.

The column with file paths is normalized and renamed to match the internal filename schema.
}
\concept{ingestion}
