% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varE.R
\name{varE}
\alias{varE}
\title{varE: Calculate Variance Estimate}
\usage{
varE(data, conf.level = 0.95, df = 1.2, lower = 1e-08, upper = 1e+06, k)
}
\arguments{
\item{data}{A numeric vector functioning as a sample data.}

\item{conf.level}{A confidence level for CI method.}

\item{df}{A degree of freedom for LI method in terms of the denominator degree of freedom of F-test, as (n-df) of LRT, where n is the sample size of input data. For a variance estimation, it is suggested to be 1.2.}

\item{lower}{A lower bound of "uniroot" for lower limit (LL) calculation. 1e-08 is a default.}

\item{upper}{A upper bound of "uniroot" for upper limit (UL) calculation. 1e+06 is a default.}

\item{k}{A cutoff value for LI method. Unless specified, F-test is used.}
}
\value{
Point Estimate (PE), lower limit/bound (LL/LB), upper limit/bound (UL/UB), width, sample size, cutoff value k and maximum log-likelihood function value are calculated.
}
\description{
This function computes the interval estimation for a single group variance by both LI and CI method.
}
\examples{
x <- rnorm(20, 0, 1)
varE(x)

y <- rnorm(40, 0, 1)
varE(y)

}
