% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_recycle.R
\name{recycle}
\alias{recycle}
\title{Strictly recycle function parameters}
\usage{
recycle(..., .min = 1, .env = rlang::caller_env())
}
\arguments{
\item{...}{the variables to recycle}

\item{.min}{the minimum length of the results (defaults to 1)}

\item{.env}{the environment to recycle within.}
}
\value{
the length of the longest variable
}
\description{
\code{recycle} is called within a function and ensures the parameters in the
calling function are all the same length by repeating them using \code{rep}. This
function alters the environment from which it is called. It is stricter than
R recycling in that it will not repeat vectors other than length one to match
the longer ones, and it throws more informative errors.
}
\details{
NULL values are not recycled, missing values are ignored.
}
\examples{
testfn = function(a, b, c) {
  n = recycle(a,b,c)
  print(a)
  print(b)
  print(c)
  print(n)
}

testfn(a=c(1,2,3), b="needs recycling", c=NULL)
try(testfn(a=c(1,2,3), c=NULL))

testfn(a=character(), b=integer(), c=NULL)

# inconsistent to have a zero length and a non zero length
try(testfn(a=c("a","b"), b=integer(), c=NULL))

}
\concept{parameter_checks}
