% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_clint.R
\name{plot_clint}
\alias{plot_clint}
\title{Plot Mass Spectrometry Responses from Measurements of Intrinsic
Hepatic Clearance}
\usage{
plot_clint(level2, dtxsid, color.palette = "viridis")
}
\arguments{
\item{level2}{(Data Frame) A data frame containing level-2 data with a measure
of chemical clearance over time when incubated with suspended hepatocytes.}

\item{dtxsid}{(Character) EPA's DSSTox Structure ID for the chemical to be plotted.}

\item{color.palette}{(Character) A character string indicating which 
\code{viridis} R package color map option to use. (Defaults to "viridis".)}
}
\value{
\item{ggplot2}{A figure of mass spectrometry responses over time for
various sample types.}
}
\description{
This function generates a response-versus-time plot of mass spectrometry (MS) 
responses collected from measurements of intrinsic hepatic clearance for a chemical.
Responses from different measurements/calibrations are labeled with different colors, 
and responses from various sample types are labeled with different shapes.
}
\details{
The function requires "level-2" data for plotting. Level-2 data is level-1,
data formatted with the \code{\link{format_clint}} function, and curated
with a verification column. "Y" in the verification column indicates the
data row is valid for plotting.
}
\examples{
## Load example level-2 data 
level2 <- invitroTKstats::clint_L2
plot_clint(level2, dtxsid = "DTXSID1021116")

}
\author{
John Wambaugh
}
