% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_check.R
\name{key_check}
\alias{key_check}
\title{Quick Key Quality Check}
\usage{
key_check(x, y, by, warn = TRUE)
}
\arguments{
\item{x}{A data frame (left table in the join).}

\item{y}{A data frame (right table in the join).}

\item{by}{A character vector of column names to join by.}

\item{warn}{Logical. If \code{TRUE} (default), prints warnings for detected issues.
Set to \code{FALSE} for silent operation.}
}
\value{
Invisibly returns a logical: \code{TRUE} if no issues detected, \code{FALSE} otherwise.
Also prints a brief status message unless \code{warn = FALSE}.
}
\description{
A fast check of join key quality that returns a simple pass/fail status
with a brief summary. Use this for quick validation; use \code{\link[=join_spy]{join_spy()}} for
detailed diagnostics.
}
\examples{
orders <- data.frame(id = c(1, 2, 2, 3), value = 1:4)
customers <- data.frame(id = c(1, 2, 4), name = c("A", "B", "D"))

# Quick check
key_check(orders, customers, by = "id")

# Silent check
is_ok <- key_check(orders, customers, by = "id", warn = FALSE)

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=key_duplicates]{key_duplicates()}}
}
