% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_repair.R
\name{suggest_repairs}
\alias{suggest_repairs}
\title{Suggest Repair Code}
\usage{
suggest_repairs(report)
}
\arguments{
\item{report}{A \code{JoinReport} object from \code{\link[=join_spy]{join_spy()}}.}
}
\value{
Character vector of R code snippets to fix detected issues.
}
\description{
Analyzes join issues and returns R code snippets to fix them.
}
\examples{
orders <- data.frame(id = c("A ", "B"), val = 1:2, stringsAsFactors = FALSE)
customers <- data.frame(id = c("a", "b"), name = c("Alice", "Bob"), stringsAsFactors = FALSE)

report <- join_spy(orders, customers, by = "id")
suggest_repairs(report)

}
\seealso{
\code{\link[=join_repair]{join_repair()}}, \code{\link[=join_spy]{join_spy()}}
}
