% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_magnitude.R
\name{set_magnitude_count}
\alias{set_magnitude_count}
\title{Set magnitude for count-space numbers}
\usage{
set_magnitude_count(
  x,
  mag = NULL,
  count_label_thousands = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{[num] numeric vector}

\item{mag}{[chr: default NULL] magnitude override: NULL (auto), "t", "m", "b"}

\item{count_label_thousands}{[lgl: default FALSE] allow "thousands" magnitude (not Lancet-valid)}

\item{verbose}{[lgl: default TRUE] verbose warnings}
}
\value{
[data.frame] with columns: mag, mag_label, denom
}
\description{
Counts are values >= 1 that are scaled down by dividing by large denominators.
E.g., 55,831,000 / 1e6 = 55.831 "million"
}
\seealso{
Other magnitudes: 
\code{\link{fmt_magnitude}()},
\code{\link{set_magnitude}()},
\code{\link{set_magnitude_prop}()},
\code{\link{set_magnitude_rate}()}
}
\concept{magnitudes}
\keyword{internal}
