% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_xy}
\alias{check_xy}
\title{Check tables X and Y}
\usage{
check_xy(x, y)
}
\arguments{
\item{x}{data frame: referred to as \emph{left} in R terminology, or \emph{master} in
Stata terminology.}

\item{y}{data frame: referred to as \emph{right} in R terminology, or \emph{using} in
Stata terminology.}
}
\value{
invisible TRUE
}
\description{
This function performs checks inspired on merge.data.table: it detects errors
\itemize{
\item if x and/or y have no columns
\item if x and/or y contain duplicate column names
}
}
\examples{
\dontrun{
# Check passing with no errors
library(data.table)
x1 = data.table(id = c(1L, 1L, 2L, 3L, NA_integer_),
                t  = c(1L, 2L, 1L, 2L, NA_integer_),
                x  = 11:15)
y1 = data.table(id = c(1,2, 4),
                y  = c(11L, 15L, 16))
joyn:::check_xy(x = x1, y=y1)
}
}
\keyword{internal}
