% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_exporter_functions.R
\name{export_as_docx_j}
\alias{export_as_docx_j}
\title{Export a VTableTree or a listing_df object into docx}
\usage{
export_as_docx_j(
  tt,
  tblid,
  output_dir,
  theme = theme_docx_default_j(font = "Times New Roman", font_size = 9L, bold = NULL),
  add_page_break = FALSE,
  titles_as_header = TRUE,
  integrate_footers = TRUE,
  section_properties = officer::prop_section(page_size = officer::page_size(width = 11,
    height = 8.5, orient = orientation), page_margins = officer::page_mar(bottom = 1, top
    = 1, right = 1, left = 1, gutter = 0, footer = 1, header = 1)),
  doc_metadata = NULL,
  template_file = system.file("template_file.docx", package = "junco"),
  orientation = "portrait",
  paginate = FALSE,
  nosplitin = character(),
  string_map = junco::default_str_map,
  markup_df_docx = dps_markup_df_docx,
  combined_docx = FALSE,
  tlgtype = (utils::getFromNamespace("tlg_type", "junco"))(tt),
  col_gap = ifelse(tlgtype == "Listing", 0.5, 3),
  pagenum = ifelse(tlgtype == "Listing", TRUE, FALSE),
  round_type = formatters::obj_round_type(tt),
  alignments = list(),
  border = flextable::fp_border_default(width = 0.75, color = "black"),
  border_mat = make_header_bordmat(obj = tt),
  watermark = FALSE,
  ...
)
}
\arguments{
\item{tt}{a VTableTree or a listing_df object to export.}

\item{tblid}{Character. Output ID to be displayed in the Title and last line of footer.}

\item{output_dir}{a directory path to save the docx.}

\item{theme}{(optional) a function factory. See theme_docx_default_j()
or rtables.officer::theme_docx_default() for more details.}

\item{add_page_break}{(optional) Default = FALSE.}

\item{titles_as_header}{(optional) Default = TRUE.}

\item{integrate_footers}{(optional) Default = TRUE.}

\item{section_properties}{(optional). A "prop_section" object containing
information about page size, orientation, margins, etc.
See officer::prop_section() for more details.
No need to be specified by end user.}

\item{doc_metadata}{(optional). Default = NULL.}

\item{template_file}{(optional). Default = "doc/template_file.docx".
Paragraph styles are inherited from this file.}

\item{orientation}{(optional) Default = "portrait".
One of: "portrait", "landscape".}

\item{paginate}{(optional) Default = FALSE.}

\item{nosplitin}{(optional) Default = character(). Named list.}

\item{string_map}{(optional) Default = default_str_map.}

\item{markup_df_docx}{(optional) Default = dps_markup_df_docx.}

\item{combined_docx}{(optional). Default = FALSE. Whether to also export an "allparts"
docx version.}

\item{tlgtype}{(optional). No need to be specified by end user.}

\item{col_gap}{(optional). Default = 3 (Tables) or 0.5 (Listings).}

\item{pagenum}{(optional). Whether to display page numbers. Only applicable
to listings (i.e. for tables and figures this argument is ignored).}

\item{round_type}{(\code{"iec"} or \code{"sas"})\cr the type of rounding to perform. iec,
the default, performs rounding compliant with IEC 60559, while
sas performs nearest-value rounding consistent with rounding within SAS.
See \verb{[formatters::format_value()]} for more details.}

\item{alignments}{(\code{list})\cr List of named lists. Vectorized.
(Default = \code{list()}) Used to specify individual column or cell alignments.
Each named list contains \code{row}, \code{col}, and \code{value}.}

\item{border}{(optional) an \code{fp_border} object.}

\item{border_mat}{(\code{matrix})\cr A \verb{m x k} matrix where m is the number of columns of \code{tt}
and k is the number of lines the header takes up. See \link[tidytlg:add_bottom_borders]{tidytlg::add_bottom_borders}
for what the matrix should contain. Users should only specify this when the
default behavior does not meet their needs.}

\item{watermark}{(\code{logical})\cr whether to display the watermark "Confidential".
By default, this is set to FALSE. In the future, this argument will be the
actual watermark (i.e. a string) to display.}

\item{...}{other parameters.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is based on \code{\link[rtables.officer:export_as_docx]{rtables.officer::export_as_docx()}}.
See notes to understand why this is experimental.
}
\note{
This function has been tested for common use cases but may not work or have
unexpected or undesired behavior in corner cases. As such it is not considered
fully production ready and is being made available for further testing
and early adoption. Please report any issues you encounter to the developers.
This function may be removed from junco in the future if the functionality
is merged into \code{rtables.officer}.
}
