% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_lsmeans_wide.R
\name{lsmeans_wide_cfun}
\alias{lsmeans_wide_cfun}
\title{Content Row Analysis Function for LS Means Wide Table Layouts}
\usage{
lsmeans_wide_cfun(
  df,
  labelstr,
  .spl_context,
  variables,
  ref_level,
  treatment_levels,
  pval_sided = c("2", "1", "-1"),
  conf_level,
  formats
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{variables}{(\code{list})\cr see \code{\link[=fit_ancova]{fit_ancova()}} for required variable
specifications.}

\item{ref_level}{(\code{string})\cr the reference level of the treatment arm variable.}

\item{treatment_levels}{(\code{character})\cr the non-reference levels of the treatment arm
variable.}

\item{pval_sided}{(\code{string})\cr either '2' for two-sided or '1' for 1-sided with greater than
control or '-1' for 1-sided with smaller than control alternative hypothesis.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{formats}{(\code{list})\cr including \code{lsmean}, \code{mse}, \code{df}, \code{lsmean_diff}, \code{se},
\code{ci}, \code{pval} formats.}
}
\description{
Content Row Analysis Function for LS Means Wide Table Layouts
}
\details{
This assumes a lot of structure of the layout, and is only intended to be used inside
\code{\link[=summarize_lsmeans_wide]{summarize_lsmeans_wide()}}, please see there for the layout structure that is needed.
}
\keyword{internal}
