% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_to_tblfile.R
\name{tt_to_tlgrtf}
\alias{tt_to_tlgrtf}
\title{TableTree to .rtf Conversion}
\usage{
tt_to_tlgrtf(
  tt,
  file = NULL,
  orientation = c("portrait", "landscape"),
  colwidths = def_colwidths(tt, fontspec, col_gap = col_gap, label_width_ins =
    label_width_ins, type = tlgtype),
  label_width_ins = 2,
  watermark = NULL,
  pagenum = ifelse(tlgtype == "Listing", TRUE, FALSE),
  fontspec = font_spec("Times", 9L, 1.2),
  pg_width = pg_width_by_orient(orientation == "landscape"),
  margins = c(0, 0, 0, 0),
  paginate = tlg_type(tt) == "Table",
  col_gap = ifelse(tlgtype == "Listing", 0.5, 3),
  nosplitin = list(row = character(), col = character()),
  verbose = FALSE,
  tlgtype = tlg_type(tt),
  string_map = default_str_map,
  markup_df = dps_markup_df,
  combined_rtf = FALSE,
  one_table = TRUE,
  border_mat = make_header_bordmat(obj = tt),
  round_type = obj_round_type(tt),
  alignments = list(),
  validate = TRUE,
  ...
)
}
\arguments{
\item{tt}{(\code{TableTree})\cr TableTree object to convert to RTF}

\item{file}{(\code{character(1)})\cr File to create, including path, but excluding
.rtf extension.}

\item{orientation}{(\code{character})\cr Orientation of the output ("portrait" or "landscape")}

\item{colwidths}{(\code{numeric} vector)\cr Column widths for the table}

\item{label_width_ins}{(\code{numeric})\cr Label width in inches}

\item{watermark}{(optional) String containing the desired watermark for
RTF outputs. Vectorized.}

\item{pagenum}{(\code{logical})\cr Whether to add page numbers to the output.
Only applicable to listings (i.e. it is ignored for tables and figures).}

\item{fontspec}{(\code{font_spec})\cr Font specification object}

\item{pg_width}{(\code{numeric})\cr Page width in inches}

\item{margins}{(\code{numeric} vector)\cr Margins in inches (top, right, bottom, left)}

\item{paginate}{(\code{logical})\cr Whether to paginate the output}

\item{col_gap}{(\code{numeric})\cr Column gap in spaces}

\item{nosplitin}{(\code{list})\cr list(row=, col=). Path elements whose children should not be paginated within
if it can be avoided. e.g., list(col="TRT01A") means don't split within treatment arms unless
all the associated columns don't fit on a single page.}

\item{verbose}{(\code{logical})\cr Whether to print verbose output}

\item{tlgtype}{(\code{character})\cr Type of the output (Table, Listing, or Figure)}

\item{string_map}{(\code{data.frame})\cr Unicode mapping for special characters}

\item{markup_df}{(\code{data.frame})\cr Data frame containing markup information}

\item{combined_rtf}{(\code{logical(1)})\cr In the case where the result is broken up into multiple
parts due to width, should a combined rtf file also be created. Defaults to \code{FALSE}.}

\item{one_table}{(\code{logical(1)})\cr If \code{tt} is a (non-\code{MatrixPrintForm}) list,
should the parts be added to the rtf within a single table (\code{TRUE}, the
default) or as separate tables. End users will not generally need to set this.}

\item{border_mat}{(\code{matrix})\cr A \verb{m x k} matrix where m is the number of columns of \code{tt}
and k is the number of lines the header takes up. See \link[tidytlg:add_bottom_borders]{tidytlg::add_bottom_borders}
for what the matrix should contain. Users should only specify this when the
default behavior does not meet their needs.}

\item{round_type}{(\code{character(1)})\cr the type of rounding to perform.
See \code{\link[formatters:format_value]{formatters::format_value()}} for more details.}

\item{alignments}{(\code{list})\cr List of named lists. Vectorized.
(Default = \code{list()}) Used to specify individual column or cell alignments.
Each named list contains \code{row}, \code{col}, and \code{value}, which are passed to
\code{\link[huxtable:align]{huxtable::set_align()}} to set the alignments.}

\item{validate}{logical(1). Whether to validate the table structure using
\code{rtables::validate_table_struct()}. Defaults to \code{TRUE}. If \code{FALSE}, a message
will be displayed when validation fails.}

\item{...}{Additional arguments passed to gentlg}
}
\value{
If \code{file} is non-NULL, this is called for the side-effect of writing
one or more RTF files. Otherwise, returns a list of \code{huxtable} objects.
}
\description{
A function to convert TableTree to .rtf
}
\details{
This function aids in converting the rtables TableTree into the desired .rtf file.
}
\note{
\code{file} should always include path. Path will be extracted
and passed separately to \code{gentlg}.

When \code{one_table} is \code{FALSE}, only the width of the row label
pseudocolumn can be directly controlled due to a limitation in
\code{tidytlg::gentlg}. The proportion of the full page that the first value
in colwidths would take up is preserved and all other columns equally
split the remaining available width. This will cause, e.g., the
elements within the allparts rtf generated when \code{combined_rtf} is \code{TRUE}
to differ visually from the content of the individual part rtfs.
}
