% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-id.R
\name{bind_id}
\alias{bind_id}
\title{Bind data frames with ID handling}
\usage{
bind_id(..., .id = ".id")
}
\arguments{
\item{...}{Data frames to bind.}

\item{.id}{Column name for IDs (default: ".id").}
}
\value{
Combined data frame with valid IDs for all rows.
}
\description{
Binds data frames while properly handling ID columns. Checks for
overlapping IDs, combines the data, and fills in missing IDs.
}
\details{
This function:
\enumerate{
\item Checks if IDs overlap between datasets (warns if so)
\item Binds rows using \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}
\item Fills missing IDs using \code{\link[=extend_id]{extend_id()}}
}

Use this instead of \code{dplyr::bind_rows()} when working with ID columns.
}
\examples{
df1 <- add_id(data.frame(x = 1:3))
df2 <- data.frame(x = 4:6)
combined <- bind_id(df1, df2)

}
