% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftinv.R
\name{ftinv}
\alias{ftinv}
\title{Inverse of the fuzzy transform}
\usage{
ftinv(fit, x, xmemb)
}
\arguments{
\item{fit}{The fuzzy transform object as the instance of the \code{ft} S3 class}

\item{x}{The numeric matrix of input values, for which the inverse fuzzy transform
has to be computed}

\item{xmemb}{the partitioning of input values, i.e., a \code{fsets} object with membership degrees
(see \code{\link[=fcut]{fcut()}}). Such partitioning must correspond to the \code{xmemb} partitioning used to
create \code{fit} using the \code{\link[=ft]{ft()}} function.}
}
\value{
The inverse of the fuzzy transform \code{fit}, i.e., the approximated values
of the original function that was the subject of the fuzzy transform
}
\description{
Compute an inverse of fuzzy transform \code{fit} for values \code{x} with corresponding
membership degrees \code{xmemb}.
}
\examples{

# create the fuzzy transform object
y <- (1:30)^2
x <- as.matrix(data.frame(a = 1:30, b = 30:1))
xmemb <- fcut(x,
              breaks = list(a = equidist(x[, 'a'], 3),
                            b = equidist(x[, 'b'], 3)))
fit <- ft(x, xmemb, y, order = 1)

# obtain function values
x2 <- as.matrix(data.frame(a = 10:20, b = 20:10))
xmemb2 <- fcut(x2,
               breaks = list(a = equidist(x[, 'a'], 3),
                             b = equidist(x[, 'b'], 3)))
y2 <- ftinv(fit, x2, xmemb2)
print(y2)

# compare original values with those obtained by the fuzzy transform
y - y2

}
\references{
Perfilieva I. Fuzzy transforms: Theory and applications. FUZZY SET SYST,
volume 157, issue 8, p. 993-1023. 2006.
}
\seealso{
\code{\link[=ft]{ft()}}, \code{\link[=is.ft]{is.ft()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
