% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slicesDeprecated.R
\name{slices}
\alias{slices}
\title{Return vector of values from given interval}
\usage{
slices(from, to, n)
}
\arguments{
\item{from}{The lower bound of the interval.}

\item{to}{The upper bound of the interval.}

\item{n}{The length of the vector to be produced.}
}
\value{
A vector of numbers in the given interval and size.
}
\description{
Returns an ordered vector of values from given interval, of given size,
generated by equal steps.
}
\details{
Returns a vector of values from \code{from} to \code{to} (inclusive), with
equal difference between two consecutive values, with total length \code{n}.
Function is useful e.g., together with the \code{\link{pbld}} or
\code{\link{defuzz}} functions (for the \code{values} argument; see also
\code{\link{lcut}} or \code{\link{fcut}}) or \code{\link{defuzz}}).
}
\examples{
\dontrun{
    slices(1, 5, 10) # 1, 1.5, 2, 2.5, 3, 3.5 4, 4.5, 5
}
# is the same as
seq(1, 5, length.out=10)


}
\seealso{
\code{\link{pbld}}, \code{\link{defuzz}}, \code{\link{fcut}},
\code{\link{lcut}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
