% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_roi.R
\name{clip}
\alias{clip}
\alias{clip_roi}
\alias{clip_rectangle}
\alias{clip_polygon}
\alias{clip_circle}
\alias{clip_transect}
\title{Clip points in regions of interest}
\usage{
clip_roi(las, geometry, ...)

clip_rectangle(las, xleft, ybottom, xright, ytop, ...)

clip_polygon(las, xpoly, ypoly, ...)

clip_circle(las, xcenter, ycenter, radius, ...)

clip_transect(las, p1, p2, width, xz = FALSE, ...)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{geometry}{a geometric object. spatial points, spatial polygons in sp or sf/sfc format, Extent,
bbox, 2x2 matrix}

\item{...}{in \code{clip_roi}: optional supplementary options (see supported geometries). Unused in
other functions}

\item{xleft, ybottom, xright, ytop}{numeric. coordinates of one or several rectangles.}

\item{xpoly, ypoly}{numeric. x coordinates of a polygon.}

\item{xcenter, ycenter}{numeric. x coordinates of on or several disc centres.}

\item{radius}{numeric. disc radius or radii.}

\item{p1, p2}{numeric vectors of length 2 that gives the coordinates of two points that define a
transect}

\item{width}{numeric. width of the transect.}

\item{xz}{bool. If \code{TRUE} the point cloud is reoriented to fit on XZ coordinates}
}
\value{
If the input is a LAS object: an object of class LAS, or a \code{list} of LAS objects if the
query implies several regions of interest.\cr\cr
If the input is a LAScatalog object: an object of class LAS, or a \code{list} of LAS
objects if the query implies several regions of interest, or a LAScatalog if the
queries are immediately written into files without loading anything in R.
}
\description{
Clip points within a given region of interest (ROI) from a point cloud (LAS object) or a collection
of files (LAScatalog object).
}
\section{Non-supported LAScatalog options}{

The option \verb{chunk size}, \code{buffer}, \verb{chunk alignment} and \code{select} are not supported by \verb{clip_*}
because they are meaningless in this context.
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")

# Load the file and clip the region of interest
las = readLAS(LASfile, select = "xyz", filter = "-keep_first")
subset1 = clip_rectangle(las, 684850, 5017850, 684900, 5017900)

# Do not load the file(s), extract only the region of interest
# from a bigger dataset
ctg = readLAScatalog(LASfile, progress = FALSE, filter = "-keep_first")
subset2 = clip_rectangle(ctg, 684850, 5017850, 684900, 5017900)

# Extract all the polygons from a shapefile
f <- system.file("extdata", "lake_polygons_UTM17.shp", package = "lidR")
lakes <- sf::st_read(f, quiet = TRUE)
subset3 <- clip_roi(las, lakes)

# Extract the polygons for a catalog, write them in files named
# after the lake names, do not load anything in R
opt_output_files(ctg) <- paste0(tempfile(), "_{LAKENAME_1}")
new_ctg = clip_roi(ctg, lakes)
plot(new_ctg)

# Extract a transect
p1 <- c(684800, y = 5017800)
p2 <- c(684900, y = 5017900)
tr1 <- clip_transect(las, p1, p2, width = 4)

\dontrun{
plot(subset1)
plot(subset2)
plot(subset3)

plot(tr1, axis = TRUE, clear_artifacts = FALSE)
}
}
