% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_palette.R
\name{desaturate_ltc}
\alias{desaturate_ltc}
\title{Desaturate Palette Colors}
\usage{
desaturate_ltc(palette_name, amount = 0.5, which = NULL)
}
\arguments{
\item{palette_name}{Character or unquoted name. Name of the ltc palette.}

\item{amount}{Numeric. Desaturation amount (0 to 1).
0 = no change, 1 = completely gray.}

\item{which}{Integer vector. Which colors to desaturate.
If NULL (default), affects all colors.}
}
\value{
A vector of desaturated hex color codes with class "ltc"
}
\description{
Reduce color saturation (make colors more gray).
}
\examples{
\donttest{
# Desaturate entire palette
desaturate_ltc(luminaries, amount = 0.5)

# Desaturate only specific colors
desaturate_ltc("heatmap2", amount = 0.7, which = c(1, 2))
}
}
