% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{luz_callback_metrics}
\alias{luz_callback_metrics}
\title{Metrics callback}
\usage{
luz_callback_metrics()
}
\value{
A \code{luz_callback}
}
\description{
Tracks metrics passed to \code{\link[=setup]{setup()}} during training and validation.
}
\details{
This callback takes care of 2 \link{ctx} attributes:
\itemize{
\item \code{ctx$metrics}: stores the current metrics objects that are initialized once for epoch,
and are further \code{update()}d and \code{compute()}d every batch. You will rarely need
to work with these metrics.
\item \code{ctx$records$metrics}: Stores metrics per training/validation and epoch. The
structure is very similar to \code{ctx$losses}.
}
}
\note{
In general you won't need to explicitly use the metrics callback as it's
used by default in \code{\link[=fit.luz_module_generator]{fit.luz_module_generator()}}.
}
\seealso{
Other luz_callbacks: 
\code{\link{luz_callback}()},
\code{\link{luz_callback_auto_resume}()},
\code{\link{luz_callback_csv_logger}()},
\code{\link{luz_callback_early_stopping}()},
\code{\link{luz_callback_interrupt}()},
\code{\link{luz_callback_keep_best_model}()},
\code{\link{luz_callback_lr_scheduler}()},
\code{\link{luz_callback_mixed_precision}()},
\code{\link{luz_callback_mixup}()},
\code{\link{luz_callback_model_checkpoint}()},
\code{\link{luz_callback_profile}()},
\code{\link{luz_callback_progress}()},
\code{\link{luz_callback_resume_from_checkpoint}()},
\code{\link{luz_callback_train_valid}()}
}
\concept{luz_callbacks}
