% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_serial_parallel}
\alias{data_serial_parallel}
\title{Sample Dataset:
Serial-Parallel Mediation}
\format{
A data frame with 100 rows
and 7 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{m11}{Mediator 1 in Path 1. Numeric.}
\item{m12}{Mediator 2 in Path 1. Numeric.}
\item{m2}{Mediator in Path 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_serial_parallel
}
\description{
A mediation model with
both serial and parallel components.
}
\examples{
library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ a11 * x + c1 + c2
m12 ~ b11 * m11 + x + c1 + c2
m2 ~ a2 * x + c1 + c2
y ~ b12 * m12 + b2 * m2 + m11 + x + c1 + c2
indirect1 := a11 * b11 * b12
indirect2 := a2 * b2
indirect := a11 * b11 * b12 + a2 * b2
"
fit <- sem(mod, data_serial_parallel,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 4, 8, 11, 12, 34:36), ]
}
\keyword{datasets}
