% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc2est_lavaan.R
\name{fit2mc_out}
\alias{fit2mc_out}
\title{Monte Carlo Estimates for a
\code{lavaan} Output}
\usage{
fit2mc_out(fit, progress = TRUE, compute_implied_stats = TRUE)
}
\arguments{
\item{fit}{The fit object. This
function only supports a
\link[lavaan:lavaan-class]{lavaan::lavaan} object.
It can also be
a \code{lavaan.mi} object
returned by
\code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::lavaan.mi()}} or
its wrapper, such as \code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::sem.mi()}}.}

\item{progress}{Logical. Display
progress or not. Default is \code{TRUE}.}

\item{compute_implied_stats}{If
\code{TRUE}, default, implied statistics
will be computed for each replication.
Letting users to disable this
is an experimental features to let
the process run faster.}
}
\value{
A \code{mc_out}-class object
that can be used for the \code{mc_out}
argument of \code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, and
related functions for forming
Monte Carlo confidence intervals.

The object is a list with the number
of elements equal to the number of
Monte Carlo replications. Each element
is a
list of the parameter estimates and
sample variances and covariances of
the variables in each Monte Carlo
replication.
}
\description{
Generate Monte Carlo
estimates from the output of
\code{\link[lavaan:sem]{lavaan::sem()}}.
}
\details{
This function is for
advanced users. \code{\link[=do_mc]{do_mc()}} is a
function users should try first
because \code{\link[=do_mc]{do_mc()}} has a general
interface for input-specific
functions like this one.

\code{\link[=fit2mc_out]{fit2mc_out()}} can be used
to extract the stored Monte Carlo
estimates so that they can be reused
by \code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} and related
functions to form Monte Carlo
confidence intervals for effects such
as indirect effects and conditional
indirect effects.

This approach removes the need to
repeat Monte Carlo simulation in each
call to
\code{\link[=indirect_effect]{indirect_effect()}},
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, and
related functions. It also ensures
that the same set of Monte Carlo
estimates is used in all subsequent
analyses.
}
\examples{

library(lavaan)
data(data_med_mod_ab1)
dat <- data_med_mod_ab1
dat$"x:w" <- dat$x * dat$w
dat$"m:w" <- dat$m * dat$w
mod <-
"
m ~ x + w + x:w + c1 + c2
y ~ m + w + m:w + x + c1 + c2
"

fit <- sem(model = mod, data = dat, fixed.x = FALSE,
           baseline = FALSE)
# In real research, R should be 5000 or even 10000.
fit <- gen_mc_est(fit, R = 100, seed = 453253)
fit_mc_out <- fit2mc_out(fit)
out <- cond_indirect_effects(wlevels = "w",
                             x = "x",
                             y = "y",
                             m = "m",
                             fit = fit,
                             mc_ci = TRUE,
                             mc_out = fit_mc_out)
out

}
\seealso{
\code{\link[=do_mc]{do_mc()}}, the general
purpose function that users should
try first before using this function.
}
