% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leg_draw.R
\name{leg_draw}
\alias{leg_draw}
\title{Plot a composed map legend}
\usage{
leg_draw(
  x,
  pos = "bottomright",
  size = 1,
  bg = "#f7f7f7",
  fg = "#333333",
  frame = TRUE,
  frame_border = fg,
  title_cex = 0.8 * size,
  val_cex = 0.6 * size,
  adj = c(0, 0),
  mar = par("mar")
)
}
\arguments{
\item{x}{list of legend parameters}

\item{pos}{position of the legend. . It can be one of 'topleft',
'topright', 'right', 'bottomright', 'bottomleft' or 'left',}

\item{size}{size of the legend; 2 means two times bigger}

\item{bg}{background color of the legend}

\item{fg}{foreground color of the legend}

\item{frame}{if TRUE the legend is plotted within a frame}

\item{frame_border}{border color of the frame}

\item{title_cex}{size of the legend title}

\item{val_cex}{size of the values in the legend}

\item{adj}{adjust the postion of the legend in x and y directions.}

\item{mar}{plot margins}
}
\value{
A composed legend is plotted. Nothing is returned.
}
\description{
Draw a map legend with several elements.
}
\examples{
# minimal example
plot.new()
plot.window(xlim = c(0, 1), ylim = c(0, 1), asp = 1)
box()
leg_comp(type = "prop", val = c(10, 50, 100)) |>
  leg_comp(type = "typo", val = c("A", "B", "C")) |>
  leg_draw(pos = "topright", bg = "lightblue")
}
