% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle_arc.R
\name{v_arc_left_up}
\alias{v_arc_left_up}
\alias{v_arc_right_up}
\alias{v_arc_left_down}
\alias{v_arc_right_down}
\alias{h_arc_left_up}
\alias{h_arc_right_up}
\alias{h_arc_left_down}
\alias{h_arc_right_down}
\title{Coordinates for drawing circle arches}
\usage{
v_arc_left_up(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  vis = 1,
  lty = 1,
  lwd = 3
)

v_arc_right_up(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  lty = 1,
  lwd = 3,
  vis = 1
)

v_arc_left_down(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  lty = 1,
  lwd = 3,
  vis = 1,
  pos.x = 0,
  pos.y = 0
)

v_arc_right_down(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  lty = 1,
  lwd = 3,
  vis = 1,
  pos.x = 0,
  pos.y = 0
)

h_arc_left_up(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  lty = 1,
  lwd = 3,
  vis = 1,
  pos.x = 0,
  pos.y = 0
)

h_arc_right_up(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  lty = 1,
  lwd = 3,
  vis = 1,
  pos.x = 0,
  pos.y = 0
)

h_arc_left_down(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  lty = 1,
  lwd = 3,
  vis = 1,
  pos.x = 0,
  pos.y = 0
)

h_arc_right_down(
  size.x = square()$size.x[[1]]/2,
  size.y = size.x,
  lty = 1,
  lwd = 3,
  vis = 1,
  pos.x = 0,
  pos.y = 0
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is square()$size.x[[1]]/2}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{vis}{Visibility of the figure. Default is 1, making the figure visible. To hide the figure, change it to 0}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line)}

\item{lwd}{integer, define the line width of the figure. Default is 3}
}
\value{
Return the coordinates for drawing the left up arch of a circle

Return the coordinates for drawing the right up arch of a circle

Return the coordinates for drawing the left down arch of a circle

Return the coordinates for drawing the right down arch of a circle

Return the coordinates for drawing the left up arch of a circle

Return the coordinates for drawing the right up arch of a circle

Return the coordinates for drawing the left down arch of a circle

Return the coordinates for drawing the right down arch
}
\description{
Define the coordinates for drawing different circle arches
}
\section{Functions}{
\itemize{
\item \code{v_arc_right_up()}: Coordinates of a vertical right up arch

Define the coordinates for drawing the right up arch of a circle

\item \code{v_arc_left_down()}: Coordinates of a vertical left down arch

Define the coordinates for drawing the left down arch of a circle

\item \code{v_arc_right_down()}: Coordinates of a vertical right down arch

Define the coordinates for drawing f the right down arch of a circle

\item \code{h_arc_left_up()}: Coordinates of a horizontal left up arch

Define the coordinates for drawing the left up arch of a circle

\item \code{h_arc_right_up()}: Coordinates of a horizontal right up arch

Define the coordinates for drawing the right up arch of a circle

\item \code{h_arc_left_down()}: Coordinates of a horizontal left down arch

Define the coordinates for drawing the left down arch of a circle

\item \code{h_arc_right_down()}: Coordinates of a horizontal right down arch

Define the coordinates for drawing the right down arch of a circle

}}
\examples{
# default coordinates of the left up arch
v_arc_left_up()
# default coordinates of the right up arch
v_arc_right_up()
# default coordinates of the left down arch
v_arc_left_down()
# default coordinates of the right down arch
v_arc_right_down()
# default coordinates of the left up arch
h_arc_left_up()
# default coordinates of the right up arch
h_arc_right_up()
# default coordinates of the left down arch
h_arc_left_down()
# default coordinates of the right down arch
h_arc_right_down()
}
