% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eight_shapes_figures.R
\name{vertical_eight}
\alias{vertical_eight}
\alias{horizontal_eight}
\alias{s_vertical_eight}
\alias{s_horizontal_eight}
\title{Eight-shaped figures}
\usage{
vertical_eight(lwd = 3, lty = 1)

horizontal_eight(lwd = 3, lty = 1)

s_vertical_eight(lwd = 3, lty = 1)

s_horizontal_eight(lwd = 3, lty = 1)
}
\arguments{
\item{lwd}{integer, define the line width of the figure. Default is 3.}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line).}
}
\value{
Return the coordinates for drawing a vertical eight-shaped figure

Return the coordinates for drawing an horizontal eight-shaped figure

Return the coordinates for drawing a single vertical eight-shaped figure to be used in shape()

Return the coordinates for drawing a single horizontal eight-shaped figure to be used in shape()
}
\description{
Define the coordinates for drawing eight-shaped figures
vertical_eight defines the coordinates for drawing a vertical eight-shaped figures.
}
\section{Functions}{
\itemize{
\item \code{horizontal_eight()}: Coordinates of an horizontal eight

Define the coordinates for drawing an horizontal eight-shaped figure

\item \code{s_vertical_eight()}: Coordinates of a single vertical eight

Define the coordinates for drawing a single vertical eight-shaped figure, to be used in shape()

\item \code{s_horizontal_eight()}: Coordinates of a single horizontal eight

Define the coordinates for drawing a single vertical eight-shaped figure, to be used in shape()

}}
\examples{
# default coordinates of the vertical eight-shaped figure
vertical_eight()
# change the line type
vertical_eight(lty = 2)
# default coordinates of the horizontal eight-shaped figure
horizontal_eight()
# change the line type
horizontal_eight(lty = 2)
# default coordinates of the single vertical eight-shaped figure
s_vertical_eight()
# change the line type
s_vertical_eight(lty = 2)
# default coordinates of a single horizontal eight-shaped figure
s_horizontal_eight()
# change the line type
s_horizontal_eight(lty = 2)
}
