.onAttach <- function(libname, pkgname) {

  startup_msg <- c(
    "",
    "                         *",
    "                      *     *",
    "                   *           *",
    "                *                 *",
    "             *      /         /#   | *",
    "          *        -|---------##   |    *",
    "       *            /    |    \\#   |       * ",
    "    *                    |         |          *",
    "    *                    #\\        |          *",
    "    *                   ## \\       |          *",
    "    *                  ###  \\     /|          *",
    "    *                 ####   \\   / |          *",
    "    *                #####====\\ /  |          *",
    "    *                #####    |/   |          *",
    "    *      ####      #####    |   /           *",
    "    *      ####      #####    |  /            *",
    "    *      ####      #####    | /             *",
    "       *   ####      #####    |/           *",
    "          * |========#####====|         *",
    "             *       #####    |      *",
    "                *    #####    |   *",
    "                   * #####     *",
    "                      *###  *",
    "                         * ",
    paste0("This is version ", utils::packageVersion(pkgname),
           " of ", pkgname),
    "",
    paste0("Contact the package maintainer",
           " (Phillip Alderman <phillip.alderman@okstate.edu>) for any queries",
           " regarding the R package.",
           collapse = ""),
    "",
    paste0("DATA USE IS SUBJECT TO STANDARD FEES unless otherwise stated in",
           " the Oklahoma Mesonet data access and pricing policy",
           " (https://mesonet.org/about/data-access-and-pricing).",
           collapse = ""),
    "",
    paste0("All Oklahoma Mesonet data are copyrighted and have quality",
           " assurance pre-applied.",
           " Redistribution of the data is prohibited except as allowed by the",
           " data access policy. Penalty is termination of access to data and",
           " possible legal action to recover lost revenue.",
           collapse = ""),
    "",
    paste0("For further details about data access and pricing see",
           " https://mesonet.org/about/data-access-and-pricing or contact",
           " datarequest@mesonet.org.",
           collapse = ""),
    "",
    paste0("Use of this R package or Oklahoma Mesonet data should be cited in",
           " publications following the guidlines provided by typing",
           " 'citation(\"mesonet\")'.",
           collapse = "")) |>
    paste0("\n")

  packageStartupMessage(startup_msg, appendLF = TRUE)
}
