% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.dars.R
\name{mica.dar.actions}
\alias{mica.dar.actions}
\title{Get data access request actions}
\usage{
mica.dar.actions(mica, id, df = TRUE)
}
\arguments{
\item{mica}{A Mica object}

\item{id}{Data access request identifier}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the actions history of a specific data access request.
}
\examples{
\dontrun{
m <- mica.login("someuser", "somepassword", "https://mica-demo.obiba.org")
mica.dar.actions(m, "12345")
mica.logout(m)
}
}
\seealso{
Other data access requests functions: 
\code{\link{mica.dar}()},
\code{\link{mica.dar.agreements}()},
\code{\link{mica.dar.amendment}()},
\code{\link{mica.dar.amendment.form}()},
\code{\link{mica.dar.amendment.history}()},
\code{\link{mica.dar.amendments}()},
\code{\link{mica.dar.amendments.history}()},
\code{\link{mica.dar.form}()},
\code{\link{mica.dar.history}()},
\code{\link{mica.dar.preliminaries}()},
\code{\link{mica.dar.preliminary}()},
\code{\link{mica.dar.preliminary.history}()},
\code{\link{mica.dars}()}
}
\concept{data access requests functions}
