% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.dars.R
\name{mica.dar.preliminary.history}
\alias{mica.dar.preliminary.history}
\title{Get data access request history preliminary form}
\usage{
mica.dar.preliminary.history(mica, id, df = TRUE)
}
\arguments{
\item{mica}{A Mica object}

\item{id}{Data access request identifier}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the history of a specific data access request preliminary form.
}
\examples{
\dontrun{
m <- mica.login("someuser", "somepassword", "https://mica-demo.obiba.org")
mica.dar.preliminary.history(m, "12345")
mica.logout(m)
}
}
\seealso{
Other data access requests functions: 
\code{\link{mica.dar}()},
\code{\link{mica.dar.actions}()},
\code{\link{mica.dar.agreements}()},
\code{\link{mica.dar.amendment}()},
\code{\link{mica.dar.amendment.form}()},
\code{\link{mica.dar.amendment.history}()},
\code{\link{mica.dar.amendments}()},
\code{\link{mica.dar.amendments.history}()},
\code{\link{mica.dar.form}()},
\code{\link{mica.dar.history}()},
\code{\link{mica.dar.preliminaries}()},
\code{\link{mica.dar.preliminary}()},
\code{\link{mica.dars}()}
}
\concept{data access requests functions}
