% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micvar.R
\name{gen_coef_mat}
\alias{gen_coef_mat}
\title{Simulate coefficient matrices with specified density}
\usage{
gen_coef_mat(k, coefmin, coefmax, dens)
}
\arguments{
\item{k}{Integer. Dimension of process.}

\item{coefmin}{Numeric. Minimum value of coefficient. See Details.}

\item{coefmax}{Numeric. Maximum value of coefficient. See Details.}

\item{dens}{Numeric. Must be between 0 and 1. Specifies the proportion of non-zero entries in the coefficient matrix. The number of non-zero entries is computed as \code{floor(k^2*dens)}.}
}
\value{
\code{k x k} matrix.
}
\description{
Simulates coefficient matrices used to generate data from a vector autoregressive process.
}
\details{
Coefficient values are drawn from a Uniform(coefmin, coefmax) or a Uniform(-coefmax, -coefmin) each with 50\% probability.
}
\examples{
# bivariate coefficient matrix
coefmat <- gen_coef_mat(k = 2, coefmin = 0.1, coefmax = 0.3, dens = 0.8)
print(coefmat)
}
